/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.paimon.fileindex.FileIndexPredicate;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.TableSchema;

public class FileIndexEvaluator {
    public static FileIndexResult evaluate(FileIO fileIO, TableSchema dataSchema, List<Predicate> dataFilter, DataFilePathFactory dataFilePathFactory, DataFileMeta file) throws IOException {
        if (dataFilter != null && !dataFilter.isEmpty()) {
            byte[] embeddedIndex = file.embeddedIndex();
            if (embeddedIndex != null) {
                try (FileIndexPredicate predicate = new FileIndexPredicate(embeddedIndex, dataSchema.logicalRowType());){
                    FileIndexResult fileIndexResult = predicate.evaluate(PredicateBuilder.and(dataFilter.toArray(new Predicate[0])));
                    return fileIndexResult;
                }
            }
            List indexFiles = file.extraFiles().stream().filter(name -> name.endsWith(".index")).collect(Collectors.toList());
            if (!indexFiles.isEmpty()) {
                if (indexFiles.size() > 1) {
                    throw new RuntimeException("Found more than one index file for one data file: " + String.join((CharSequence)" and ", indexFiles));
                }
                try (FileIndexPredicate predicate = new FileIndexPredicate(dataFilePathFactory.toAlignedPath((String)indexFiles.get(0), file), fileIO, dataSchema.logicalRowType());){
                    FileIndexResult fileIndexResult = predicate.evaluate(PredicateBuilder.and(dataFilter.toArray(new Predicate[0])));
                    return fileIndexResult;
                }
            }
        }
        return FileIndexResult.REMAIN;
    }
}

