/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.roaringbitmap.buffer;

import org.apache.paimon.shade.org.roaringbitmap.PeekableCharIterator;
import org.apache.paimon.shade.org.roaringbitmap.buffer.MappeableBitmapContainer;

final class MappeableBitmapContainerCharIterator
implements PeekableCharIterator {
    private static final int len = 1024;
    private long w;
    int x;
    private MappeableBitmapContainer parent;

    MappeableBitmapContainerCharIterator() {
    }

    MappeableBitmapContainerCharIterator(MappeableBitmapContainer p) {
        this.wrap(p);
    }

    @Override
    public PeekableCharIterator clone() {
        try {
            return (PeekableCharIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.x < 1024;
    }

    @Override
    public char next() {
        char answer = (char)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
        this.w &= this.w - 1L;
        while (this.w == 0L) {
            ++this.x;
            if (this.x == 1024) break;
            this.w = this.parent.bitmap.get(this.x);
        }
        return answer;
    }

    @Override
    public int nextAsInt() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new RuntimeException("unsupported operation: remove");
    }

    void wrap(MappeableBitmapContainer p) {
        this.parent = p;
        this.x = 0;
        while (this.x < 1024 && (this.w = this.parent.bitmap.get(this.x)) == 0L) {
            ++this.x;
        }
    }

    @Override
    public void advanceIfNeeded(char minval) {
        if (!this.hasNext()) {
            return;
        }
        if (minval >= this.x * 64) {
            if (minval >= (this.x + 1) * 64) {
                this.x = minval / 64;
                this.w = this.parent.bitmap.get(this.x);
            }
            this.w &= -1L << (minval & 0x3F);
            while (this.w == 0L) {
                ++this.x;
                if (this.x == 1024) {
                    return;
                }
                this.w = this.parent.bitmap.get(this.x);
            }
        }
    }

    @Override
    public char peekNext() {
        return (char)(this.x * 64 + Long.numberOfTrailingZeros(this.w));
    }
}

