/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.VarBinaryType;
import org.apache.paimon.types.VarCharType;

public class SerializationUtils {
    public static void serializeBytes(DataOutputView out, byte[] binary) throws IOException {
        out.writeInt(binary.length);
        out.write(binary);
    }

    public static byte[] deserializedBytes(DataInputView in) throws IOException {
        int len = in.readInt();
        byte[] buf = new byte[len];
        int off = 0;
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new EOFException();
            }
            toRead -= ret;
            off += ret;
        }
        return buf;
    }

    public static VarBinaryType newBytesType(boolean isNullable) {
        return new VarBinaryType(isNullable, Integer.MAX_VALUE);
    }

    public static VarCharType newStringType(boolean isNullable) {
        return new VarCharType(isNullable, Integer.MAX_VALUE);
    }

    public static byte[] serializeBinaryRow(BinaryRow row) {
        byte[] bytes = MemorySegmentUtils.copyToBytes(row.getSegments(), row.getOffset(), row.getSizeInBytes());
        ByteBuffer buffer = ByteBuffer.allocate(4 + bytes.length);
        buffer.putInt(row.getFieldCount()).put(bytes);
        return buffer.array();
    }

    public static BinaryRow deserializeBinaryRow(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int arity = buffer.getInt();
        BinaryRow row = new BinaryRow(arity);
        row.pointTo(MemorySegment.wrap(bytes), 4, bytes.length - 4);
        return row;
    }

    public static void serializeBinaryRow(BinaryRow row, DataOutputView out) throws IOException {
        out.writeInt(4 + row.getSizeInBytes());
        out.writeInt(row.getFieldCount());
        MemorySegmentUtils.copyToView(row.getSegments(), row.getOffset(), row.getSizeInBytes(), out);
    }

    public static BinaryRow deserializeBinaryRow(DataInputView input) throws IOException {
        return SerializationUtils.deserializeBinaryRow(SerializationUtils.deserializedBytes(input));
    }
}

