/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.hive.HiveCatalog;
import org.apache.flink.table.catalog.hive.client.HiveShimLoader;
import org.apache.flink.test.util.AbstractTestBaseJUnit4;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.FlinkGenericCatalog;
import org.apache.paimon.flink.FlinkGenericCatalogFactory;
import org.apache.paimon.hive.annotation.Minio;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.s3.MinioTestContainer;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public class FlinkGenericCatalogITCase
extends AbstractTestBaseJUnit4 {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    protected String path;
    protected TableEnvironment tEnv;
    @HiveSQL(files={})
    protected static HiveShell hiveShell;
    @Minio
    private static MinioTestContainer minioTestContainer;

    private static HiveCatalog createHiveCatalog(HiveConf hiveConf) {
        return new HiveCatalog("testcatalog", null, hiveConf, HiveShimLoader.getHiveVersion(), true);
    }

    @Before
    public void before() throws Exception {
        this.path = this.folder.newFolder().toURI().toString();
        hiveShell.execute("CREATE DATABASE IF NOT EXISTS test_db");
        hiveShell.execute("USE test_db");
        hiveShell.execute("CREATE TABLE hive_table ( a INT, b STRING )");
        hiveShell.execute("INSERT INTO hive_table VALUES (100, 'Hive'), (200, 'Table')");
        hiveShell.executeQuery("SHOW TABLES");
        this.tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        HiveCatalog hiveCatalog = FlinkGenericCatalogITCase.createHiveCatalog(hiveShell.getHiveConf());
        FlinkGenericCatalog catalog = FlinkGenericCatalogFactory.createCatalog((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), Collections.singletonMap("warehouse", this.path), (String)hiveCatalog.getName(), (Catalog)hiveCatalog);
        catalog.open();
        this.tEnv.registerCatalog(hiveCatalog.getName(), (Catalog)catalog);
        this.sql("USE CATALOG " + hiveCatalog.getName(), new Object[0]);
        this.sql("USE test_db", new Object[0]);
    }

    @After
    public void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
        hiveShell.execute("DROP DATABASE IF EXISTS test_db2 CASCADE");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Row> sql(String query, Object ... args) {
        try (CloseableIterator iter = this.tEnv.executeSql(String.format(query, args)).collect();){
            ImmutableList immutableList = ImmutableList.copyOf((Iterator)iter);
            return immutableList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testPaimonTableToBlackHole() {
        this.sql("CREATE TABLE paimon_t ( f0 INT, f1 INT ) WITH ('connector'='paimon', 'file.format' = 'avro' )", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM paimon_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        this.sql("CREATE TABLE bh (f0 INT, f1 INT) WITH ('connector'='blackhole')", new Object[0]);
        this.sql("INSERT INTO bh SELECT * FROM paimon_t", new Object[0]);
    }

    @Test
    public void testReadPaimonSystemTable() {
        this.sql("CREATE TABLE paimon_t (\n    user_id BIGINT,\n    item_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    PRIMARY KEY (dt, user_id) NOT ENFORCED\n) PARTITIONED BY (dt)  WITH ('connector'='paimon', 'file.format' = 'avro' )", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 2, 'click', '2023-11-01')", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (2, 3, 'click', '2023-11-02')", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (3, 4, 'click', '2023-11-03')", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (4, 5, 'click', '2023-11-04')", new Object[0]);
        List<Row> result = this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots", new Object[0]);
        Assertions.assertThat(result).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1L, 0L, "APPEND"}), Row.of((Object[])new Object[]{2L, 0L, "APPEND"}), Row.of((Object[])new Object[]{3L, 0L, "APPEND"}), Row.of((Object[])new Object[]{4L, 0L, "APPEND"})});
        List<Row> result1 = this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots where snapshot_id>0", new Object[0]);
        Assertions.assertThat(result1).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1L, 0L, "APPEND"}), Row.of((Object[])new Object[]{2L, 0L, "APPEND"}), Row.of((Object[])new Object[]{3L, 0L, "APPEND"}), Row.of((Object[])new Object[]{4L, 0L, "APPEND"})});
        List<Row> result2 = this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots where snapshot_id=2", new Object[0]);
        Assertions.assertThat(result2).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2L, 0L, "APPEND"})});
        AssertionsForClassTypes.assertThatThrownBy(() -> this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots where snapshot_id=6", new Object[0])).hasCauseInstanceOf(RuntimeException.class).hasRootCauseMessage("snapshot upper id:6 should not greater than latestSnapshotId:4");
        List<Row> result3 = this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots where snapshot_id>1 and snapshot_id<5", new Object[0]);
        Assertions.assertThat(result3).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2L, 0L, "APPEND"}), Row.of((Object[])new Object[]{3L, 0L, "APPEND"}), Row.of((Object[])new Object[]{4L, 0L, "APPEND"})});
        AssertionsForClassTypes.assertThatThrownBy(() -> this.sql("SELECT snapshot_id, schema_id, commit_kind FROM paimon_t$snapshots where snapshot_id>9", new Object[0])).hasCauseInstanceOf(RuntimeException.class).hasRootCauseMessage("snapshot upper id:10 should not greater than latestSnapshotId:4");
    }

    @Test
    public void testReadPaimonAllProcedures() {
        List<Row> result = this.sql("SHOW PROCEDURES", new Object[0]);
        Assertions.assertThat(result).contains((Object[])new Row[]{Row.of((Object[])new Object[]{"compact"}), Row.of((Object[])new Object[]{"merge_into"}), Row.of((Object[])new Object[]{"migrate_table"})});
    }

    @Test
    public void testCreateTag() {
        this.sql("CREATE TABLE paimon_t ( f0 INT, f1 INT ) WITH ('connector'='paimon', 'file.format' = 'avro' )", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM paimon_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        this.sql("CALL sys.create_tag('test_db.paimon_t', 'tag_1')", new Object[0]);
        List<Row> result = this.sql("SELECT tag_name FROM paimon_t$tags", new Object[0]);
        Assertions.assertThat(result).contains((Object[])new Row[]{Row.of((Object[])new Object[]{"tag_1"})});
    }

    @Test
    public void testCreateView() {
        this.sql("CREATE TABLE paimon_t ( f0 INT, f1 INT ) WITH ('connector'='paimon')", new Object[0]);
        this.sql("INSERT INTO paimon_t VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM paimon_t", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        this.sql("CREATE VIEW paimon_t_view AS SELECT * FROM paimon_t WHERE f0=1", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM paimon_t_view", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1})});
    }
}

