/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.flink.FormatCatalogTable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.utils.CompressUtils;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.model.Statement;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public abstract class HiveCatalogFormatTableITCaseBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    protected String path;
    protected TableEnvironment tEnv;
    @HiveSQL(files={})
    protected static HiveShell hiveShell;
    @Rule
    public TestRule environmentRule = (base, description) -> new Statement(){

        public void evaluate() throws Throwable {
            try {
                HiveCatalogFormatTableITCaseBase.this.before(description.getAnnotation(LocationInProperties.class) != null);
                base.evaluate();
            }
            finally {
                HiveCatalogFormatTableITCaseBase.this.after();
            }
        }
    };

    private void before(boolean locationInProperties) throws Exception {
        this.path = this.folder.newFolder().toURI().toString();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("type", "paimon");
        options.put("metastore", "hive");
        options.put("uri", "");
        options.put("lock.enabled", "true");
        options.put("location-in-properties", String.valueOf(locationInProperties));
        options.put("warehouse", this.path);
        options.put(CatalogOptions.FORMAT_TABLE_ENABLED.key(), "true");
        this.tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        this.tEnv.executeSql(String.join((CharSequence)"\n", "CREATE CATALOG my_hive WITH (", options.entrySet().stream().map(e -> String.format("'%s' = '%s'", e.getKey(), e.getValue())).collect(Collectors.joining(",\n")), ")")).await();
        this.tEnv.executeSql("USE CATALOG my_hive").await();
        this.tEnv.executeSql("DROP DATABASE IF EXISTS test_db CASCADE");
        this.tEnv.executeSql("CREATE DATABASE test_db").await();
        this.tEnv.executeSql("USE test_db").await();
        hiveShell.execute("USE test_db");
    }

    private void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
    }

    @Test
    public void testCsvFormatTable() throws Exception {
        hiveShell.execute("CREATE TABLE csv_table (a INT COMMENT 'comment a', b STRING COMMENT 'comment b')");
        this.doTestCSVFormatTable("csv_table");
    }

    @Test
    public void testCsvFormatTableWithDelimiter() throws Exception {
        hiveShell.execute("CREATE TABLE csv_table_delimiter (a INT COMMENT 'comment a', b STRING COMMENT 'comment b') ROW FORMAT DELIMITED FIELDS TERMINATED BY ';'");
        this.doTestCSVFormatTable("csv_table_delimiter");
    }

    @Test
    public void testPartitionTable() throws Exception {
        hiveShell.execute("CREATE TABLE partition_table (a INT COMMENT 'comment a') PARTITIONED BY (b STRING COMMENT 'comment b')");
        this.doTestCSVFormatTable("partition_table");
    }

    @Test
    public void testFlinkCreateCsvFormatTable() throws Exception {
        this.tEnv.executeSql("CREATE TABLE flink_csv_table (a INT COMMENT 'comment a', b STRING COMMENT 'comment b') with ('type'='format-table', 'file.format'='csv')").await();
        this.doTestCSVFormatTable("flink_csv_table");
    }

    @Test
    public void testFlinkCreateFormatTableWithDelimiter() throws Exception {
        this.tEnv.executeSql("CREATE TABLE flink_csv_table_delimiter (a INT COMMENT 'comment a', b STRING COMMENT 'comment b') with ('type'='format-table', 'file.format'='csv', 'csv.field-delimiter'=';')");
        this.doTestCSVFormatTable("flink_csv_table_delimiter");
    }

    @Test
    public void testFlinkCreatePartitionTable() throws Exception {
        this.tEnv.executeSql("CREATE TABLE flink_partition_table (a INT COMMENT 'comment a', b STRING COMMENT 'comment b') PARTITIONED BY (b) with ('type'='format-table', 'file.format'='csv')");
        this.doTestCSVFormatTable("flink_partition_table");
    }

    @Test
    public void testJsonFormatTable() throws Exception {
        hiveShell.execute("CREATE TABLE json_table (a INT COMMENT 'comment a', b TIMESTAMP COMMENT 'comment b') ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe' STORED AS TEXTFILE");
        this.doTestJSONFormatTable("json_table");
    }

    @Test
    public void testFlinkCreateJsonFormatTable() throws Exception {
        this.tEnv.executeSql("CREATE TABLE flink_json_table (a INT COMMENT 'comment a', b TIMESTAMP COMMENT 'comment b') with ('type'='format-table', 'file.format'='json')").await();
        this.doTestJSONFormatTable("flink_json_table");
    }

    private void doTestCSVFormatTable(String tableName) throws Exception {
        List descResult = this.collect("DESC " + tableName).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(descResult).containsExactly((Object[])new String[]{"+I[a, INT, true, null, null, null, comment a]", "+I[b, STRING, true, null, null, null, comment b]"});
        hiveShell.execute(String.format("INSERT INTO %s VALUES (100, 'Hive'), (200, 'Table')", tableName));
        Assertions.assertThat(this.collect(String.format("SELECT * FROM %s", tableName))).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{100, "Hive"}), Row.of((Object[])new Object[]{200, "Table"})});
        this.tEnv.executeSql(String.format("INSERT INTO %s VALUES (300, 'Paimon')", tableName)).await();
        Assertions.assertThat(this.collect(String.format("SELECT * FROM %s", tableName))).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{100, "Hive"}), Row.of((Object[])new Object[]{200, "Table"}), Row.of((Object[])new Object[]{300, "Paimon"})});
    }

    private void doTestJSONFormatTable(String tableName) throws Exception {
        List descResult = this.collect("DESC " + tableName).stream().map(Objects::toString).collect(Collectors.toList());
        Assertions.assertThat(descResult).containsExactly((Object[])new String[]{"+I[a, INT, true, null, null, null, comment a]", "+I[b, TIMESTAMP(3), true, null, null, null, comment b]"});
        hiveShell.execute(String.format("INSERT INTO %s VALUES (1, '2025-03-17 10:15:30'), (2, '2025-03-18 10:15:30')", tableName));
        Assertions.assertThat(this.collect(String.format("SELECT * FROM %s", tableName))).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, LocalDateTime.parse("2025-03-17T10:15:30")}), Row.of((Object[])new Object[]{2, LocalDateTime.parse("2025-03-18T10:15:30")})});
        FormatCatalogTable catalogTable = (FormatCatalogTable)((Catalog)this.tEnv.getCatalog(this.tEnv.getCurrentCatalog()).get()).getTable(new ObjectPath(this.tEnv.getCurrentDatabase(), tableName));
        FormatTable table = catalogTable.table();
        FileIO fileIO = table.fileIO();
        String file = Arrays.stream(fileIO.listStatus(new Path(table.location()))).filter(status -> !status.getPath().getName().startsWith(".")).findFirst().get().getPath().toUri().getPath();
        CompressUtils.gzipCompressFile((String)file, (String)(file + ".gz"));
        fileIO.deleteQuietly(new Path(file));
        Assertions.assertThat(this.collect(String.format("SELECT * FROM %s", tableName))).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, LocalDateTime.parse("2025-03-17T10:15:30")}), Row.of((Object[])new Object[]{2, LocalDateTime.parse("2025-03-18T10:15:30")})});
        this.tEnv.executeSql(String.format("INSERT INTO %s VALUES (3, CAST('2025-03-19 10:15:30' AS TIMESTAMP))", tableName)).await();
        Assertions.assertThat(this.collect(String.format("SELECT * FROM %s", tableName))).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, LocalDateTime.parse("2025-03-17T10:15:30")}), Row.of((Object[])new Object[]{2, LocalDateTime.parse("2025-03-18T10:15:30")}), Row.of((Object[])new Object[]{3, LocalDateTime.parse("2025-03-19T10:15:30")})});
    }

    @Test
    public void testListTables() throws Exception {
        hiveShell.execute("CREATE TABLE list_table ( a INT, b STRING)");
        Assertions.assertThat(this.collect("SHOW TABLES")).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"list_table"})});
    }

    protected List<Row> collect(String sql) throws Exception {
        ArrayList<Row> result = new ArrayList<Row>();
        try (CloseableIterator it = this.tEnv.executeSql(sql).collect();){
            while (it.hasNext()) {
                result.add((Row)it.next());
            }
        }
        return result;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface LocationInProperties {
    }
}

