/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.catalog.AbstractCatalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.FileStoreTestUtils;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveCatalogFactory;
import org.apache.paimon.hive.HiveCatalogOptions;
import org.apache.paimon.hive.annotation.Minio;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.s3.MinioTestContainer;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Sets;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public class HiveLocationTest {
    @HiveSQL(files={})
    private static HiveShell hiveShell;
    @Minio
    private static MinioTestContainer minioTestContainer;
    public static final String HIVE_CONF = "/hive-conf";
    private HiveCatalog catalog;
    private IMetaStoreClient hmsClient;
    private String objectStorePath;
    private FileIO fileIO;
    private CatalogContext catalogContext;

    @Before
    public void before() throws IOException {
        this.objectStorePath = hiveShell.getBaseDir().toAbsolutePath().toString() + "/" + UUID.randomUUID();
        Options options = new Options();
        options.set(CatalogOptions.WAREHOUSE, (Object)this.objectStorePath);
        options.set(CatalogOptions.METASTORE, (Object)"hive");
        options.set(CatalogOptions.URI, (Object)"");
        options.set(CatalogOptions.LOCK_ENABLED, (Object)false);
        options.set(HiveCatalogOptions.HIVE_CONF_DIR, (Object)(hiveShell.getBaseDir() + HIVE_CONF));
        options.set(HiveCatalogOptions.LOCATION_IN_PROPERTIES, (Object)true);
        for (Map.Entry stringStringEntry : minioTestContainer.getS3ConfigOptions().entrySet()) {
            options.set((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
        }
        this.catalogContext = CatalogContext.create((Options)options);
        Path warehouse = new Path(this.objectStorePath);
        this.fileIO = HiveLocationTest.getFileIO(this.catalogContext, warehouse);
        this.fileIO.mkdirs(warehouse);
        HiveCatalogFactory hiveCatalogFactory = new HiveCatalogFactory();
        this.catalog = (HiveCatalog)hiveCatalogFactory.create(this.catalogContext);
        this.hmsClient = this.catalog.getHmsClient();
        String setTemplate = "SET paimon.%s=%s";
        minioTestContainer.getS3ConfigOptions().forEach((k, v) -> hiveShell.execute(String.format(setTemplate, k, v)));
    }

    private static FileIO getFileIO(CatalogContext catalogContext, Path warehouse) {
        FileIO fileIO;
        try {
            fileIO = FileIO.get((Path)warehouse, (CatalogContext)catalogContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return fileIO;
    }

    @After
    public void after() throws Exception {
        this.catalog.close();
        hiveShell.execute("DROP DATABASE IF EXISTS database1 CASCADE");
    }

    @Test
    public void testCatalogDBLocation() throws Exception {
        HashSet dbs = Sets.newHashSet((Object[])new String[]{"db1", "db2", "db3", "db4", "db5"});
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String db : dbs) {
            this.catalog.createDatabase(db, true);
            Assertions.assertThat((Comparable)this.hmsClient.getDatabase(db)).isNotNull();
            Path actual = this.catalog.newDatabasePath(db);
            Path expected = new Path(this.objectStorePath + "/" + db + ".db");
            Assertions.assertThat((boolean)this.fileIO.exists(expected)).isTrue();
            Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
            paths.add(expected);
        }
        HashSet dbsExpected = Sets.newHashSet((Object[])new String[]{"db1", "db2", "db3", "db4", "db5", "default"});
        Assertions.assertThat((Collection)Sets.newHashSet((Iterable)this.catalog.listDatabases())).isEqualTo((Object)dbsExpected);
        for (String db : dbs) {
            this.catalog.dropDatabase(db, false, true);
        }
        for (Path p : paths) {
            Assertions.assertThat((boolean)this.fileIO.exists(p)).isFalse();
        }
        Assertions.assertThat((Collection)Sets.newHashSet((Iterable)this.catalog.listDatabases())).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"default"}));
    }

    @Test
    public void testCatalogTableLocation() throws Exception {
        String db = "db";
        String table = "table";
        this.catalog.createDatabase(db, true);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT()}, (String[])new String[]{"aaa"});
        Identifier tableIdentifier = Identifier.create((String)db, (String)table);
        this.catalog.createTable(tableIdentifier, new Schema(rowType.getFields(), Collections.emptyList(), Collections.emptyList(), new HashMap(), ""), false);
        Table hmsClientTablea = this.hmsClient.getTable(tableIdentifier.getDatabaseName(), tableIdentifier.getObjectName());
        String location = (String)hmsClientTablea.getParameters().get("paimon_location");
        String expected = this.objectStorePath + "/" + db + ".db/" + table;
        Assertions.assertThat((boolean)this.fileIO.exists(new Path(expected))).isTrue();
        Assertions.assertThat((String)location).isEqualTo(expected);
    }

    @Test
    public void testExternTableLocation() throws Exception {
        String path = minioTestContainer.getS3UriForDefaultBucket() + "/" + UUID.randomUUID();
        Options conf = new Options();
        conf.set(CatalogOptions.WAREHOUSE, (Object)path);
        for (Map.Entry stringStringEntry : minioTestContainer.getS3ConfigOptions().entrySet()) {
            conf.set((String)stringStringEntry.getKey(), (String)stringStringEntry.getValue());
        }
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.INT()}, (String[])new String[]{"aaa"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createTableWithStorageLocation(path, rowType, "test_extern_table", conf, true)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("No FileSystem for scheme: s3");
        HashSet tableForTest = Sets.newHashSet((Object[])new String[]{"test_extern_table1", "hive_inner_table1"});
        int i = 0;
        for (String table : tableForTest) {
            this.createTableWithPropertiesLocation(path, rowType, table, conf, ++i % 2 == 0);
        }
        HashSet tableInHive = Sets.newHashSet((Iterable)hiveShell.executeQuery("show tables"));
        Assertions.assertThat((Collection)tableInHive).isEqualTo((Object)tableForTest);
    }

    @Test
    public void testRWIT() {
        String[][] params;
        String dbName = "database1";
        String createDbStr = String.format("create database %s ;", dbName);
        String useDbStr = String.format("use %s ;", dbName);
        hiveShell.execute(createDbStr);
        hiveShell.execute(useDbStr);
        for (String[] param : params = new String[][]{{"table1", this.objectStorePath}, {"table2", this.objectStorePath}}) {
            String tableName = param[0];
            String warehouse = param[1];
            Identifier identifier = Identifier.create((String)dbName, (String)tableName);
            String location = AbstractCatalog.newTableLocation((String)warehouse, (Identifier)identifier).toUri().toString();
            String createTableSqlStr = this.getCreateTableSqlStr(tableName, location, false);
            this.testRWinHive(createTableSqlStr, location, tableName);
        }
        String associationSql = "select a,b from table1 union all select a,b from table2";
        List result = hiveShell.executeQuery(associationSql);
        Assertions.assertThat(Arrays.asList("3\tPaimon", "3\tPaimon")).isEqualTo((Object)result);
    }

    private String getCreateTableSqlStr(String tableName, String location, boolean locationInProperties) {
        String createTable = String.format("CREATE TABLE %s (\n    a INT COMMENT 'The a field',\n    b STRING COMMENT 'The b field'\n)\nSTORED BY 'org.apache.paimon.hive.PaimonStorageHandler'", tableName);
        String partforLocation = locationInProperties ? String.format("TBLPROPERTIES (  'paimon_location'='%s' );", location) : String.format("LOCATION '%s'", location);
        return String.join((CharSequence)"\n", createTable, partforLocation);
    }

    private void testRWinHive(String createTableStr, String location, String tableName) {
        String insertStr = String.format("INSERT INTO %s VALUES (3, 'Paimon');", tableName);
        String selectStr = String.format("select count(*) from %s", tableName);
        hiveShell.execute(createTableStr);
        hiveShell.execute(insertStr);
        FileIO fIO = HiveLocationTest.getFileIO(this.catalogContext, new Path(location));
        SchemaManager schemaManager = new SchemaManager(fIO, new Path(location));
        Optional tableSchema = schemaManager.latest();
        Assertions.assertThat((Optional)tableSchema).isPresent();
        List result = hiveShell.executeQuery(selectStr);
        Assertions.assertThat((List)result).isEqualTo((Object)Lists.newArrayList((Object[])new String[]{"1"}));
    }

    private void createTableWithPropertiesLocation(String path, RowType rowType, String hiveTableName, Options conf, boolean isExtern) throws Exception {
        this.createTable(path, rowType, hiveTableName, conf, isExtern, true);
    }

    private void createTableWithStorageLocation(String path, RowType rowType, String hiveTableName, Options conf, boolean isExtern) throws Exception {
        this.createTable(path, rowType, hiveTableName, conf, isExtern, false);
    }

    private void createTable(String path, RowType rowType, String hiveTableName, Options conf, boolean isExtern, boolean locationInTBProperties) throws Exception {
        String db = "pdb";
        FileStoreTestUtils.createFileStoreTable(conf, rowType, Collections.emptyList(), Collections.emptyList(), db, hiveTableName, true);
        String location = path + "/" + db + ".db/" + hiveTableName;
        String extern = isExtern ? "EXTERNAL" : "";
        String s = locationInTBProperties ? "CREATE " + extern + " TABLE  " + hiveTableName + " \nSTORED BY 'org.apache.paimon.hive.PaimonStorageHandler'\nTBLPROPERTIES (  '" + "paimon_location" + "' ='" + location + "' )" : "CREATE " + extern + " TABLE " + hiveTableName + "\nSTORED BY 'org.apache.paimon.hive.PaimonStorageHandler'\nLOCATION '" + location + "';";
        hiveShell.execute(s);
    }
}

