/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class RandomGenericRowDataGenerator {
    public static final List<DataType> LOGICAL_TYPES = Arrays.asList(DataTypes.BOOLEAN(), DataTypes.TINYINT(), DataTypes.SMALLINT(), DataTypes.INT(), DataTypes.BIGINT(), DataTypes.FLOAT(), DataTypes.DOUBLE(), DataTypes.DECIMAL((int)5, (int)3), DataTypes.DECIMAL((int)28, (int)6), DataTypes.CHAR((int)10), DataTypes.VARCHAR((int)10), DataTypes.STRING(), DataTypes.VARBINARY((int)Integer.MAX_VALUE), DataTypes.DATE(), DataTypes.TIME(), DataTypes.TIMESTAMP((int)3), DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3), DataTypes.ARRAY((DataType)DataTypes.BIGINT()), DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()));
    public static final List<String> TYPE_NAMES = Arrays.asList("boolean", "tinyint", "smallint", "int", "bigint", "float", "double", "decimal(5,3)", "decimal(28,6)", "char(10)", "varchar(10)", "string", "binary", "date", "string", "timestamp", "timestamp", "array<bigint>", "map<string,int>");
    public static final List<String> FIELD_NAMES = Arrays.asList("f_boolean", "f_byte", "f_short", "f_int", "f_long", "f_float", "f_double", "f_decimal_5_3", "f_decimal_28_6", "f_char_10", "f_varchar_10", "f_string", "f_binary", "f_date", "f_time", "f_timestamp", "f_timestamp_ltz", "f_list_long", "f_map_string_int");
    public static final List<String> FIELD_COMMENTS = Arrays.asList("comment_boolean", "comment_byte", "comment_short", "comment_int", "comment_long", "comment_float", "comment_double", "comment_decimal_5_3", "comment_decimal_28_6", "comment_char_10", "comment_varchar_10", "comment_string", "comment_binary", "comment_date", "comment_time", "comment_timestamp", "comment_timestamp_ltz", "comment_list_long", "comment_map_string_int");
    public static final RowType ROW_TYPE = new RowType(IntStream.range(0, FIELD_NAMES.size()).mapToObj(i -> new DataField(i, FIELD_NAMES.get(i), LOGICAL_TYPES.get(i), FIELD_COMMENTS.get(i))).collect(Collectors.toList()));

    public static GenericRow generate() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        byte[] randomBytes = new byte[random.nextInt(20)];
        random.nextBytes(randomBytes);
        Object[] randomLongArray = new Long[random.nextInt(20)];
        for (int i = 0; i < randomLongArray.length; ++i) {
            randomLongArray[i] = random.nextBoolean() ? null : Long.valueOf(random.nextLong());
        }
        HashMap<BinaryString, Integer> randomMap = new HashMap<BinaryString, Integer>();
        for (int i = random.nextInt(20); i > 0; --i) {
            randomMap.put(BinaryString.fromString((String)RandomGenericRowDataGenerator.randomString(20)), random.nextInt());
        }
        GenericRow rowData = GenericRow.of((Object[])new Object[]{random.nextBoolean(), (byte)random.nextInt(-128, 128), (short)random.nextInt(Short.MIN_VALUE, 32768), random.nextInt(), random.nextLong(), Float.valueOf(random.nextFloat()), random.nextDouble(), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(5, 3), (int)5, (int)3), Decimal.fromBigDecimal((BigDecimal)RandomGenericRowDataGenerator.randomBigDecimal(28, 6), (int)28, (int)6), BinaryString.fromString((String)RandomGenericRowDataGenerator.randomString(10)), BinaryString.fromString((String)RandomGenericRowDataGenerator.randomString(10)), BinaryString.fromString((String)RandomGenericRowDataGenerator.randomString(100)), randomBytes, random.nextInt(10000), random.nextInt(86400), Timestamp.fromEpochMillis((long)random.nextLong(Integer.MAX_VALUE)), Timestamp.fromEpochMillis((long)random.nextLong(Integer.MAX_VALUE)), new GenericArray(randomLongArray), new GenericMap(randomMap)});
        for (int i = 0; i < rowData.getFieldCount(); ++i) {
            if (!random.nextBoolean()) continue;
            rowData.setField(i, null);
        }
        return rowData;
    }

    private static String randomString(int lengthBound) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder builder = new StringBuilder();
        for (int i = random.nextInt(lengthBound); i >= 0; --i) {
            builder.append((char)random.nextInt(97, 123));
        }
        return builder.toString();
    }

    public static BigDecimal randomBigDecimal(int precision, int scale) {
        int i;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < precision - scale; ++i) {
            int t = random.nextInt(10);
            builder.append(t == 0 ? 1 : t);
        }
        builder.append('.');
        for (i = 0; i < scale; ++i) {
            builder.append((char)(random.nextInt(10) + 48));
        }
        return new BigDecimal(builder.toString());
    }
}

