/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.hive.objectinspector.PaimonCharObjectInspector;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonCharObjectInspectorTest {
    @Test
    public void testCategoryAndClass() {
        PaimonCharObjectInspector oi = new PaimonCharObjectInspector(10);
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.PRIMITIVE);
        Assertions.assertThat((Comparable)oi.getPrimitiveCategory()).isEqualTo((Object)PrimitiveObjectInspector.PrimitiveCategory.CHAR);
        Assertions.assertThat((Class)oi.getJavaPrimitiveClass()).isEqualTo(HiveChar.class);
        Assertions.assertThat((Class)oi.getPrimitiveWritableClass()).isEqualTo(HiveCharWritable.class);
    }

    @Test
    public void testGetPrimitiveJavaObject() {
        PaimonCharObjectInspector oi = new PaimonCharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        HiveChar expected1 = new HiveChar("testString", 10);
        BinaryString input2 = BinaryString.fromString((String)"test");
        HiveChar expected2 = new HiveChar("test", 10);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject((Object)input1)).isEqualTo((Object)expected1);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject((Object)input2)).isEqualTo((Object)expected2);
        Assertions.assertThat((Comparable)oi.getPrimitiveJavaObject(null)).isNull();
    }

    @Test
    public void testGetPrimitiveWritableObject() {
        PaimonCharObjectInspector oi = new PaimonCharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        HiveCharWritable expected1 = new HiveCharWritable(new HiveChar("testString", 10));
        BinaryString input2 = BinaryString.fromString((String)"test");
        HiveCharWritable expected2 = new HiveCharWritable(new HiveChar("test", 10));
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input1)).isEqualTo((Object)expected1);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject((Object)input2)).isEqualTo((Object)expected2);
        Assertions.assertThat((Comparable)oi.getPrimitiveWritableObject(null)).isNull();
    }

    @Test
    public void testCopyObject() {
        PaimonCharObjectInspector oi = new PaimonCharObjectInspector(10);
        BinaryString input1 = BinaryString.fromString((String)"testString");
        Object copy1 = oi.copyObject((Object)input1);
        Assertions.assertThat((Object)copy1).isEqualTo((Object)input1);
        Assertions.assertThat((Object)copy1).isNotSameAs((Object)input1);
        HiveChar input2 = new HiveChar("test", 10);
        Object copy2 = oi.copyObject((Object)input2);
        Assertions.assertThat((Object)copy2).isEqualTo((Object)input2);
        Assertions.assertThat((Object)copy2).isNotSameAs((Object)input2);
        Assertions.assertThat((Object)oi.copyObject(null)).isNull();
    }
}

