/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.objectinspector;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.hive.objectinspector.PaimonListObjectInspector;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class PaimonListObjectInspectorTest {
    @Test
    public void testCategoryAndTypeName() {
        PaimonListObjectInspector oi = new PaimonListObjectInspector((DataType)DataTypes.STRING());
        Assertions.assertThat((Comparable)oi.getCategory()).isEqualTo((Object)ObjectInspector.Category.LIST);
        Assertions.assertThat((String)oi.getTypeName()).isEqualTo("array<string>");
    }

    @Test
    public void testGetListAndElement() {
        PaimonListObjectInspector oi = new PaimonListObjectInspector((DataType)DataTypes.STRING());
        Object[] stringDataArray = new BinaryString[]{BinaryString.fromString((String)"Hi"), BinaryString.fromString((String)"Hello"), null, BinaryString.fromString((String)"Test")};
        GenericArray arrayData = new GenericArray(stringDataArray);
        Assertions.assertThat((int)oi.getListLength((Object)arrayData)).isEqualTo(4);
        for (int i = 0; i < 4; ++i) {
            Assertions.assertThat((Object)oi.getListElement((Object)arrayData, i)).isEqualTo(stringDataArray[i]);
        }
        Assertions.assertThat((List)oi.getList((Object)arrayData)).isEqualTo(Arrays.asList(stringDataArray));
        Assertions.assertThat((int)oi.getListLength(null)).isEqualTo(-1);
        Assertions.assertThat((Object)oi.getListElement(null, 3)).isNull();
        Assertions.assertThat((List)oi.getList(null)).isNull();
    }
}

