/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled
public class CloneActionITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9088;

    @BeforeAll
    public static void beforeAll() {
        TEST_HIVE_METASTORE.start(9088);
    }

    @AfterAll
    public static void afterAll() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    @Test
    public void testClonePKTableFromPaimon() throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().setConf(TableConfigOptions.TABLE_DML_SYNC, (Object)true).build();
        String warehouse1 = this.getTempDirPath();
        String warehouse2 = this.getTempDirPath();
        this.sql(tEnv, "CREATE CATALOG catalog1 WITH ('type'='paimon', 'warehouse' = '%s')", warehouse1);
        this.sql(tEnv, "CREATE CATALOG catalog2 WITH ('type'='paimon', 'warehouse' = '%s')", warehouse2);
        this.sql(tEnv, "CREATE TABLE catalog1.`default`.src (a INT, b INT, PRIMARY KEY (a) NOT ENFORCED)", new Object[0]);
        this.sql(tEnv, "INSERT INTO catalog1.`default`.src VALUES (1, 1), (2, 2)", new Object[0]);
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", "default", "--table", "src", "--catalog_conf", "warehouse=" + warehouse1, "--target_database", "default", "--target_table", "target", "--target_catalog_conf", "warehouse=" + warehouse2, "--clone_from", "paimon"})).run();
        this.sql(tEnv, "CALL catalog2.sys.compact(`table` => 'default.target')", new Object[0]);
        List<Row> result = this.sql(tEnv, "SELECT * FROM catalog2.`default`.target", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        List<Row> show = this.sql(tEnv, "SHOW CREATE TABLE catalog2.`default`.target", new Object[0]);
        Assertions.assertThat((String)show.toString()).contains(new CharSequence[]{"PRIMARY KEY"});
    }

    @Test
    public void testCloneBucketedAppendFromPaimon() throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().setConf(TableConfigOptions.TABLE_DML_SYNC, (Object)true).build();
        String warehouse1 = this.getTempDirPath();
        String warehouse2 = this.getTempDirPath();
        this.sql(tEnv, "CREATE CATALOG catalog1 WITH ('type'='paimon', 'warehouse' = '%s')", warehouse1);
        this.sql(tEnv, "CREATE CATALOG catalog2 WITH ('type'='paimon', 'warehouse' = '%s')", warehouse2);
        this.sql(tEnv, "CREATE TABLE catalog1.`default`.src (a INT, b INT) WITH ('bucket' = '2', 'bucket-key' = 'b')", new Object[0]);
        this.sql(tEnv, "INSERT INTO catalog1.`default`.src VALUES (1, 1), (2, 2)", new Object[0]);
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", "default", "--table", "src", "--catalog_conf", "warehouse=" + warehouse1, "--target_database", "default", "--target_table", "target", "--target_catalog_conf", "warehouse=" + warehouse2, "--clone_from", "paimon"})).run();
        this.sql(tEnv, "CALL catalog2.sys.compact(`table` => 'default.target')", new Object[0]);
        List<Row> result = this.sql(tEnv, "SELECT * FROM catalog2.`default`.target", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1}), Row.of((Object[])new Object[]{2, 2})});
        List<Row> show = this.sql(tEnv, "SHOW CREATE TABLE catalog2.`default`.target", new Object[0]);
        Assertions.assertThat((String)show.toString()).contains(new CharSequence[]{"'bucket' = '2'"});
        Assertions.assertThat((String)show.toString()).contains(new CharSequence[]{"'bucket-key' = 'b'"});
    }

    @Test
    public void testMigrateOneNonPartitionedTable() throws Exception {
        String format = this.randomFormat();
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse})).run();
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
        List<Row> files = this.sql(tEnv, "SELECT file_path FROM test.`test_table$files`", new Object[0]);
        Assertions.assertThat(files).hasSize(1);
        Assertions.assertThat((String)new Path(files.get(0).getField(0).toString()).getName()).startsWith((CharSequence)"data-");
    }

    @Test
    public void testCloneWithTimestamp() throws Exception {
        String format = "orc";
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (`a` int COMMENT 'The a field',`ts` timestamp COMMENT 'The ts field') STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES (1, '2025-06-03 16:00:00')", dbName, tableName);
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse})).run();
        Assertions.assertThatCode(() -> this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0])).doesNotThrowAnyException();
        List<Row> files = this.sql(tEnv, "SELECT file_path FROM test.`test_table$files`", new Object[0]);
        Assertions.assertThat(files).hasSize(1);
        Assertions.assertThat((String)new Path(files.get(0).getField(0).toString()).getName()).startsWith((CharSequence)"data-");
    }

    @Test
    public void testMigrateOnePartitionedTable() throws Exception {
        this.testMigrateOnePartitionedTableImpl(false);
    }

    @Test
    public void testMigrateOnePartitionedTableWithFilter() throws Exception {
        this.testMigrateOnePartitionedTableImpl(true);
    }

    public void testMigrateOnePartitionedTableImpl(boolean specificFilter) throws Exception {
        String format = this.randomFormat();
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s %s", dbName, tableName, specificFilter ? "WHERE id2 = 1 OR id3 = 1" : "");
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '" + this.warehouse + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse));
        if (specificFilter) {
            args.add("--where");
            args.add("id2 = 1 OR id3 = 1");
        }
        ((CloneAction)this.createAction(CloneAction.class, args)).run();
        FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
        Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
        if (specificFilter) {
            args = new ArrayList(args.subList(0, args.size() - 1));
            args.add("id2 <> 1 AND id3 <> 1");
            ((CloneAction)this.createAction(CloneAction.class, args)).run();
            Snapshot snapshot = (Snapshot)paimonTable.latestSnapshot().get();
            Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.OVERWRITE);
            List manifests = paimonTable.manifestListReader().read(snapshot.deltaManifestList());
            Assertions.assertThat((List)manifests).noneMatch(manifest -> manifest.numDeletedFiles() > 0L);
            r1 = this.sql(tEnv, "SELECT * FROM PAIMON_GE.%s.%s", dbName, tableName);
            r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
            Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
        } else {
            ((CloneAction)this.createAction(CloneAction.class, args)).run();
            r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
            Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
        }
    }

    @Test
    public void testMigrateOnePartitionedTableAndFilterNoPartition() throws Exception {
        String format = this.randomFormat();
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        List<String> args = Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse, "--where", "id2 < 0");
        ((CloneAction)this.createAction(CloneAction.class, args)).run();
        FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
        Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
        Assertions.assertThat((Object)paimonTable.snapshotManager().earliestSnapshot()).isNull();
    }

    @Test
    public void testMigrateWholeDatabase() throws Exception {
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName1 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName2 = "hivetable2" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName, tableName1, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName, tableName1, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName2, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName, tableName2, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName1);
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName2);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_catalog_conf", "warehouse=" + this.warehouse})).run();
        List<Row> actualR1 = this.sql(tEnv, "SELECT * FROM test.%s", tableName1);
        List<Row> actualR2 = this.sql(tEnv, "SELECT * FROM test.%s", tableName2);
        Assertions.assertThatList(actualR1).containsExactlyInAnyOrderElementsOf(r1);
        Assertions.assertThatList(actualR2).containsExactlyInAnyOrderElementsOf(r2);
    }

    @Test
    public void testMigrateWholeDatabaseWithFilter() throws Exception {
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName1 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName2 = "hivetable1" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName1, this.randomFormat());
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName1, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName2, this.randomFormat());
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName1, CloneActionITCase.data(100));
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName2, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s WHERE id2=1 OR id3=1", dbName, tableName1);
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM %s.%s WHERE id2=1 OR id3=1", dbName, tableName2);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_catalog_conf", "warehouse=" + this.warehouse, "--where", "id2=1 OR id3=1"})).run();
        List<Row> actualR1 = this.sql(tEnv, "SELECT * FROM test.%s", tableName1);
        List<Row> actualR2 = this.sql(tEnv, "SELECT * FROM test.%s", tableName2);
        Assertions.assertThatList(actualR1).containsExactlyInAnyOrderElementsOf(r1);
        Assertions.assertThatList(actualR2).containsExactlyInAnyOrderElementsOf(r2);
    }

    @Test
    public void testCloneWithExistedTable() throws Exception {
        String format = this.randomFormat();
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        int ddlIndex = ThreadLocalRandom.current().nextInt(0, 4);
        tEnv.executeSql(this.ddls(format)[ddlIndex]);
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse));
        if (ddlIndex < 4) {
            AssertionsForClassTypes.assertThatThrownBy(() -> ((CloneAction)this.createAction(CloneAction.class, args)).run()).rootCause().hasMessageContaining(this.exceptionMsg()[ddlIndex]);
        } else {
            ((CloneAction)this.createAction(CloneAction.class, args)).run();
            FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
            Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
            List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
            Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
        }
    }

    @Test
    public void testCloneWithNotExistedDatabase() throws Exception {
        String format = this.randomFormat();
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse));
        ((CloneAction)this.createAction(CloneAction.class, args)).run();
        FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
        Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
    }

    @Test
    public void testMigrateWholeCatalogWithExcludedTables() throws Exception {
        String dbName1 = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName1 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName2 = "hivetable2" + StringUtils.randomNumericString((int)10);
        String dbName2 = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName3 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName4 = "hivetable2" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName1);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName1, tableName1, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName1, tableName1, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName1, tableName2, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName1, tableName2, CloneActionITCase.data(100));
        tEnv.executeSql("CREATE DATABASE " + dbName2);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName2, tableName3, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName2, tableName3, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName2, tableName4, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName2, tableName4, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList db1Tables = ImmutableList.of((Object)tableName2);
        ImmutableList db2Tables = ImmutableList.of((Object)tableName4);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_catalog_conf", "warehouse=" + this.warehouse, "--excluded_tables", dbName1 + "." + tableName1 + "," + dbName2 + "." + tableName3})).run();
        List actualDB1Tables = this.sql(tEnv, "show tables from %s", dbName1).stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        List actualDB2Tables = this.sql(tEnv, "show tables from %s", dbName2).stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        Assertions.assertThatList(actualDB1Tables).containsExactlyInAnyOrderElementsOf((Iterable)db1Tables);
        Assertions.assertThatList(actualDB2Tables).containsExactlyInAnyOrderElementsOf((Iterable)db2Tables);
    }

    @Test
    public void testMigrateWholeCatalogWithIncludedTables() throws Exception {
        String dbName1 = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName1 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName2 = "hivetable2" + StringUtils.randomNumericString((int)10);
        String dbName2 = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName3 = "hivetable1" + StringUtils.randomNumericString((int)10);
        String tableName4 = "hivetable2" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName1);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName1, tableName1, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName1, tableName1, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName1, tableName2, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName1, tableName2, CloneActionITCase.data(100));
        tEnv.executeSql("CREATE DATABASE " + dbName2);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING, id2 INT, id3 INT) STORED AS %s", dbName2, tableName3, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName2, tableName3, CloneActionITCase.data(100));
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) STORED AS %s", dbName2, tableName4, this.randomFormat());
        this.sql(tEnv, "INSERT INTO TABLE %s.%s VALUES %s", dbName2, tableName4, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList db1Tables = ImmutableList.of((Object)tableName1);
        ImmutableList db2Tables = ImmutableList.of((Object)tableName3);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_catalog_conf", "warehouse=" + this.warehouse, "--included_tables", dbName1 + "." + tableName1 + "," + dbName2 + "." + tableName3})).run();
        List actualDB1Tables = this.sql(tEnv, "show tables from %s", dbName1).stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        List actualDB2Tables = this.sql(tEnv, "show tables from %s", dbName2).stream().map(row -> row.getField(0).toString()).collect(Collectors.toList());
        Assertions.assertThatList(actualDB1Tables).containsExactlyInAnyOrderElementsOf((Iterable)db1Tables);
        Assertions.assertThatList(actualDB2Tables).containsExactlyInAnyOrderElementsOf((Iterable)db2Tables);
    }

    @Test
    public void testMigrateCsvTable() throws Exception {
        String format = "textfile";
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT) ROW FORMAT SERDE 'org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe' STORED AS %s ", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName);
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '" + this.warehouse + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse));
        ((CloneAction)this.createAction(CloneAction.class, args)).run();
        FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
        Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
    }

    @Test
    public void testMigrateJsonTable() throws Exception {
        String format = "textfile";
        String dbName = "hivedb" + StringUtils.randomNumericString((int)10);
        String tableName = "hivetable" + StringUtils.randomNumericString((int)10);
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE DATABASE " + dbName);
        this.sql(tEnv, "CREATE TABLE %s.%s (id STRING) PARTITIONED BY (id2 INT, id3 INT)ROW FORMAT SERDE 'org.apache.hive.hcatalog.data.JsonSerDe' STORED AS %s ", dbName, tableName, format);
        this.sql(tEnv, "INSERT INTO %s.%s VALUES %s", dbName, tableName, CloneActionITCase.data(100));
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s.%s", dbName, tableName);
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '" + this.warehouse + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ArrayList<String> args = new ArrayList<String>(Arrays.asList("clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9088", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse));
        ((CloneAction)this.createAction(CloneAction.class, args)).run();
        FileStoreTable paimonTable = this.paimonTable(tEnv, "PAIMON", Identifier.create((String)"test", (String)"test_table"));
        Assertions.assertThat((List)paimonTable.partitionKeys()).containsExactly((Object[])new String[]{"id2", "id3"});
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
    }

    private String[] ddls(String format) {
        String ddl0 = "CREATE TABLE test.test_table (id string, id2 int, id3 int, PRIMARY KEY (id, id2, id3) NOT ENFORCED) PARTITIONED BY (id2, id3) with ('bucket' = '-1', 'file.format' = '" + format + "');";
        String ddl1 = "CREATE TABLE test.test_table (id string, id2 int, id3 int) PARTITIONED BY (id, id3) with ('bucket' = '-1', 'file.format' = '" + format + "');";
        String ddl2 = "CREATE TABLE test.test_table (id2 int, id3 int) PARTITIONED BY (id2, id3) with ('bucket' = '-1', 'file.format' = '" + format + "');";
        String ddl3 = "CREATE TABLE test.test_table (id2 int, id3 int) PARTITIONED BY (id2, id3) with ('bucket' = '-1', 'file.format' = '" + this.randomFormat(format) + "');";
        String ddl4 = "CREATE TABLE test.test_table (id string, id2 int, id3 int) PARTITIONED BY (id2, id3) with ('bucket' = '-1', 'file.format' = '" + format + "');";
        return new String[]{ddl0, ddl1, ddl2, ddl3, ddl4};
    }

    private String[] exceptionMsg() {
        return new String[]{"Can not clone data to existed paimon table which has primary keys", "source table partition keys is not compatible with existed paimon table partition keys.", "source table partition keys is not compatible with existed paimon table partition keys.", "source table format is not compatible with existed paimon table format."};
    }

    private static String data(int i) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int m = 0; m < i; ++m) {
            stringBuilder.append("(");
            stringBuilder.append("\"");
            stringBuilder.append(97 + m);
            stringBuilder.append("\",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(")");
            if (m == i - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    private String randomFormat() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = random.nextInt(3);
        String[] formats = new String[]{"orc", "parquet", "avro", "textfile"};
        return formats[i];
    }

    private String randomFormat(String excludedFormat) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int i = random.nextInt(3);
        String[] formats = new String[]{"orc", "parquet", "avro", "textfile"};
        if (Objects.equals(excludedFormat, formats[i])) {
            return formats[(i + 1) % 3];
        }
        return formats[i];
    }

    private FileStoreTable paimonTable(TableEnvironment tEnv, String catalogName, Identifier table) throws Catalog.TableNotExistException {
        FlinkCatalog flinkCatalog = (FlinkCatalog)tEnv.getCatalog(catalogName).get();
        Catalog catalog = flinkCatalog.catalog();
        return (FileStoreTable)catalog.getTable(table);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Row> sql(TableEnvironment tEnv, String query, Object ... args) {
        String formattedQuery = String.format(query, args);
        Exception lastException = null;
        int attempt = 1;
        while (attempt <= 5) {
            try (CloseableIterator iter = tEnv.executeSql(formattedQuery).collect();){
                ImmutableList immutableList = ImmutableList.copyOf((Iterator)iter);
                return immutableList;
            }
            catch (Exception e) {
                lastException = e;
                if (attempt < 5) {
                    try {
                        Thread.sleep(60000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(lastException);
                    }
                }
                ++attempt;
            }
        }
        throw new RuntimeException(lastException);
    }
}

