/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MigrateFileProcedureITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9085;

    @BeforeEach
    public void beforeEach() {
        TEST_HIVE_METASTORE.start(9085);
    }

    @AfterEach
    public void afterEach() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"orc"}), Arguments.of((Object[])new Object[]{"avro"}), Arguments.of((Object[])new Object[]{"parquet"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testMigrateFile(String format) throws Exception {
        this.test(format);
        this.testMigrateFileAction(format);
    }

    public void test(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE TABLE hivetable (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable VALUES" + this.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9085' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE TABLE paimontable (id STRING, id2 INT, id3 INT) PARTITIONED BY (id2, id3) with ('bucket' = '-1');");
        tEnv.executeSql("CALL sys.migrate_table(connector => 'hive', source_table => 'default.hivetable', target_table => 'default.paimontable')").await();
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM paimontable").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
    }

    public void testMigrateFileAction(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE TABLE hivetable01 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable01 VALUES" + this.data(100)).await();
        tEnv.executeSql("CREATE TABLE hivetable02 (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable02 VALUES" + this.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable02");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9085' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE TABLE paimontable01 (id STRING, id2 INT, id3 INT) PARTITIONED BY (id2, id3) with ('bucket' = '-1');");
        tEnv.executeSql("CALL sys.migrate_table(connector => 'hive', source_table => 'default.hivetable01', target_table => 'default.paimontable01', delete_origin => false)").await();
        tEnv.useCatalog("HIVE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable01").collect());
        Assertions.assertThat((r1.size() == 0 ? 1 : 0) != 0);
    }

    private String data(int i) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int m = 0; m < i; ++m) {
            stringBuilder.append("(");
            stringBuilder.append("\"");
            stringBuilder.append(97 + m);
            stringBuilder.append("\",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(")");
            if (m == i - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }
}

