/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.MigrateIcebergTableAction;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateIcebergTableProcedureITCase
extends ActionITCaseBase {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateIcebergTableProcedureITCase.class);
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9087;
    @TempDir
    Path iceTempDir;
    @TempDir
    Path paiTempDir;

    @BeforeEach
    public void beforeEach() {
        TEST_HIVE_METASTORE.start(9087);
    }

    @AfterEach
    public void afterEach() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    @Test
    public void testMigrateIcebergTableProcedure() throws Exception {
        String icebergOptions;
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        ThreadLocalRandom random = ThreadLocalRandom.current();
        boolean isPartitioned = random.nextBoolean();
        boolean icebergIsHive = random.nextBoolean();
        boolean paimonIsHive = random.nextBoolean();
        boolean isNamedArgument = random.nextBoolean();
        LOG.info("isPartitioned:{}, icebergIsHive:{}, paimonIsHive:{}, isNamedArgument:{}", new Object[]{isPartitioned, icebergIsHive, paimonIsHive, isNamedArgument});
        tEnv.executeSql(this.icebergCatalogDdl(icebergIsHive));
        String icebergTable = "iceberg_" + UUID.randomUUID().toString().replace("-", "_");
        tEnv.executeSql("USE CATALOG my_iceberg");
        if (isPartitioned) {
            tEnv.executeSql(String.format("CREATE TABLE `default`.`%s` (id string, id2 int, id3 int) PARTITIONED BY (id3)", icebergTable));
        } else {
            tEnv.executeSql(String.format("CREATE TABLE `default`.`%s` (id string, id2 int, id3 int) WITH ('format-version'='2')", icebergTable));
        }
        tEnv.executeSql(String.format("INSERT INTO `default`.`%s` VALUES ('a',1,1),('b',2,2),('c',3,3)", icebergTable)).await();
        tEnv.executeSql(this.paimonCatalogDdl(paimonIsHive));
        tEnv.executeSql("USE CATALOG my_paimon");
        String string = icebergOptions = icebergIsHive ? "metadata.iceberg.storage=hive-catalog, metadata.iceberg.uri=thrift://localhost:9087" : "metadata.iceberg.storage=hadoop-catalog,iceberg_warehouse=" + this.iceTempDir;
        if (isNamedArgument) {
            tEnv.executeSql(String.format("CALL sys.migrate_iceberg_table(source_table => 'default.%s', iceberg_options => '%s')", icebergTable, icebergOptions)).await();
        } else {
            tEnv.executeSql(String.format("CALL sys.migrate_iceberg_table('default.%s','%s')", icebergTable, icebergOptions)).await();
        }
        Assertions.assertThatList(Arrays.asList(Row.of((Object[])new Object[]{"a", 1, 1}), Row.of((Object[])new Object[]{"b", 2, 2}), Row.of((Object[])new Object[]{"c", 3, 3}))).containsExactlyInAnyOrderElementsOf((Iterable)ImmutableList.copyOf((Iterator)tEnv.executeSql(String.format("SELECT * FROM `default`.`%s`", icebergTable)).collect()));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testMigrateIcebergTableAction(boolean isPartitioned) throws Exception {
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        tEnv.executeSql(this.icebergCatalogDdl(true));
        String icebergTable = "iceberg_" + UUID.randomUUID().toString().replace("-", "_");
        tEnv.executeSql("USE CATALOG my_iceberg");
        if (isPartitioned) {
            tEnv.executeSql(String.format("CREATE TABLE `default`.`%s` (id string, id2 int, id3 int) PARTITIONED BY (id3)", icebergTable));
        } else {
            tEnv.executeSql(String.format("CREATE TABLE `default`.`%s` (id string, id2 int, id3 int) WITH ('format-version'='2')", icebergTable));
        }
        tEnv.executeSql(String.format("INSERT INTO `default`.`%s` VALUES ('a',1,1),('b',2,2),('c',3,3)", icebergTable)).await();
        String icebergOptions = "metadata.iceberg.storage=hive-catalog, metadata.iceberg.uri=thrift://localhost:9087";
        HashMap<String, String> catalogConf = new HashMap<String, String>();
        catalogConf.put("warehouse", this.paiTempDir.toString());
        catalogConf.put("metastore", "hive");
        catalogConf.put("uri", "thrift://localhost:9087");
        catalogConf.put("cache-enabled", "false");
        MigrateIcebergTableAction migrateIcebergTableAction = new MigrateIcebergTableAction("default." + icebergTable, catalogConf, icebergOptions, "", Integer.valueOf(6));
        migrateIcebergTableAction.run();
        tEnv.executeSql(this.paimonCatalogDdl(true));
        tEnv.executeSql("USE CATALOG my_paimon");
        Assertions.assertThatList(Arrays.asList(Row.of((Object[])new Object[]{"a", 1, 1}), Row.of((Object[])new Object[]{"b", 2, 2}), Row.of((Object[])new Object[]{"c", 3, 3}))).containsExactlyInAnyOrderElementsOf((Iterable)ImmutableList.copyOf((Iterator)tEnv.executeSql(String.format("SELECT * FROM `my_paimon`.`default`.`%s`", icebergTable)).collect()));
    }

    private String icebergCatalogDdl(boolean isHive) {
        return isHive ? String.format("CREATE CATALOG my_iceberg WITH ( 'type' = 'iceberg', 'catalog-type' = 'hive', 'uri' = 'thrift://localhost:%s', 'warehouse' = '%s', 'cache-enabled' = 'false')", 9087, this.iceTempDir) : String.format("CREATE CATALOG my_iceberg WITH ( 'type' = 'iceberg', 'catalog-type' = 'hadoop','warehouse' = '%s', 'cache-enabled' = 'false' )", this.iceTempDir);
    }

    private String paimonCatalogDdl(boolean isHive) {
        return isHive ? String.format("CREATE CATALOG my_paimon WITH ( 'type' = 'paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:%s', 'warehouse' = '%s', 'cache-enabled' = 'false' )", 9087, this.iceTempDir) : String.format("CREATE CATALOG my_paimon WITH ('type' = 'paimon', 'warehouse' = '%s')", this.paiTempDir);
    }
}

