/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.MigrateTableAction;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class MigrateTableProcedureITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9084;

    @BeforeEach
    public void beforeEach() {
        TEST_HIVE_METASTORE.start(9084);
    }

    @AfterEach
    public void afterEach() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{"orc"}), Arguments.of((Object[])new Object[]{"avro"}), Arguments.of((Object[])new Object[]{"parquet"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testMigrateProcedure(String format) throws Exception {
        this.testUpgradeNonPartitionTable(format);
        this.resetMetastore();
        this.testUpgradePartitionTable(format);
    }

    private void resetMetastore() throws Exception {
        TEST_HIVE_METASTORE.stop();
        TEST_HIVE_METASTORE.reset();
        TEST_HIVE_METASTORE.start(9084);
    }

    public void testUpgradePartitionTable(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE TABLE hivetable (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9084' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CALL sys.migrate_table(connector => 'hive', source_table => 'default.hivetable', options => 'file.format=" + format + "')").await();
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
    }

    public void testUpgradeNonPartitionTable(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE TABLE hivetable (id string, id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9084' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CALL sys.migrate_table(connector => 'hive', source_table => 'default.hivetable', options => 'file.format=" + format + "')").await();
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
    }

    @ParameterizedTest
    @ValueSource(strings={"orc", "parquet", "avro"})
    public void testMigrateAction(String format) throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG HIVE WITH ('type'='hive')");
        tEnv.useCatalog("HIVE");
        tEnv.getConfig().setSqlDialect(SqlDialect.HIVE);
        tEnv.executeSql("CREATE TABLE hivetable (id string) PARTITIONED BY (id2 int, id3 int) STORED AS " + format);
        tEnv.executeSql("INSERT INTO hivetable VALUES" + MigrateTableProcedureITCase.data(100)).await();
        tEnv.executeSql("SHOW CREATE TABLE hivetable");
        tEnv.getConfig().setSqlDialect(SqlDialect.DEFAULT);
        tEnv.executeSql("CREATE CATALOG PAIMON_GE WITH ('type'='paimon-generic')");
        tEnv.useCatalog("PAIMON_GE");
        ImmutableList r1 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        HashMap<String, String> catalogConf = new HashMap<String, String>();
        catalogConf.put("metastore", "hive");
        catalogConf.put("uri", "thrift://localhost:9084");
        catalogConf.put("warehouse", System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        MigrateTableAction migrateTableAction = new MigrateTableAction("hive", "default.hivetable", catalogConf, "", Integer.valueOf(6));
        migrateTableAction.run();
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9084' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        ImmutableList r2 = ImmutableList.copyOf((Iterator)tEnv.executeSql("SELECT * FROM hivetable").collect());
        Assertions.assertThatList((List)r1).containsExactlyInAnyOrderElementsOf((Iterable)r2);
    }

    protected static String data(int i) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder();
        for (int m = 0; m < i; ++m) {
            stringBuilder.append("(");
            stringBuilder.append("\"");
            stringBuilder.append(97 + m);
            stringBuilder.append("\",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(",");
            stringBuilder.append(random.nextInt(10));
            stringBuilder.append(")");
            if (m == i - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }
}

