/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive.procedure;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RepairAction;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RepairActionITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9082;

    @BeforeEach
    public void beforeEach() {
        TEST_HIVE_METASTORE.start(9082);
    }

    @AfterEach
    public void afterEach() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    @Test
    public void testRepairTableAction() throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql("CREATE CATALOG PAIMON WITH ('type'='paimon', 'metastore' = 'hive', 'uri' = 'thrift://localhost:9082' , 'warehouse' = '" + System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname) + "')");
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE IF NOT EXISTS test_db;").await();
        tEnv.executeSql("USE test_db").await();
        tEnv.executeSql("CREATE TABLE t_repair_hive (\n    user_id BIGINT,\n    behavior STRING,\n    dt STRING,\n    hh STRING,\n    PRIMARY KEY (dt, hh, user_id) NOT ENFORCED\n) PARTITIONED BY (dt, hh) WITH (\n'metastore.partitioned-table' = 'true'\n);").await();
        tEnv.executeSql("INSERT INTO t_repair_hive VALUES(1, 'login', '2020-01-02', '09')").await();
        HashMap<String, String> catalogConf = new HashMap<String, String>();
        catalogConf.put("metastore", "hive");
        catalogConf.put("uri", "thrift://localhost:9082");
        catalogConf.put("warehouse", System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname));
        RepairAction repairAction = new RepairAction("test_db.t_repair_hive", catalogConf);
        repairAction.run();
        ImmutableList ret = ImmutableList.copyOf((Iterator)tEnv.executeSql("SHOW PARTITIONS t_repair_hive").collect());
        Assertions.assertThat((ret.size() == 1 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((Row)ret.get(0)).toString()).isEqualTo("+I[dt=2020-01-02/hh=09]");
    }
}

