/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hudi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.hive.TestHiveMetastore;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.utils.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class CloneActionForHudiITCase
extends ActionITCaseBase {
    private static final TestHiveMetastore TEST_HIVE_METASTORE = new TestHiveMetastore();
    private static final int PORT = 9089;

    @BeforeAll
    public static void beforeAll() {
        TEST_HIVE_METASTORE.start(9089);
    }

    @AfterAll
    public static void afterAll() throws Exception {
        TEST_HIVE_METASTORE.stop();
    }

    @Test
    public void testMigrateOneNonPartitionedTable() throws Exception {
        int i;
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        String dbName = "hudidb" + StringUtils.randomNumericString((int)10);
        String tableName = "huditable" + StringUtils.randomNumericString((int)10);
        this.sql(tEnv, "CREATE TABLE %s (  id STRING PRIMARY KEY NOT ENFORCED,  name STRING,  price INT) WITH (  'connector' = 'hudi',  'path' = '%s/%s',  'table.type' = 'COPY_ON_WRITE',  'hive_sync.enable' = 'true',  'hive_sync.mode' = 'hms',  'hive_sync.metastore.uris' = 'thrift://localhost:%s',  'hive_sync.db' = '%s',  'hive_sync.table' = '%s')", tableName, System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), tableName, 9089, dbName, tableName);
        ArrayList<String> insertValues = new ArrayList<String>();
        for (i = 0; i < 50; ++i) {
            insertValues.add(String.format("('%s', '%s', %s)", i, "A", i));
        }
        this.sql(tEnv, "INSERT INTO %s VALUES %s", tableName, String.join((CharSequence)",", insertValues));
        insertValues.clear();
        for (i = 0; i < 50; ++i) {
            insertValues.add(String.format("('%s', '%s', %s)", i, "B", i));
        }
        this.sql(tEnv, "INSERT INTO %s VALUES %s", tableName, String.join((CharSequence)",", insertValues));
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s", tableName);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9089", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse})).run();
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
    }

    @Test
    public void testMigrateOnePartitionedTable() throws Exception {
        int i;
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        String dbName = "hudidb" + StringUtils.randomNumericString((int)10);
        String tableName = "huditable" + StringUtils.randomNumericString((int)10);
        this.sql(tEnv, "CREATE TABLE %s (  id STRING PRIMARY KEY NOT ENFORCED,  name STRING,  pt STRING) PARTITIONED BY (pt) WITH (  'connector' = 'hudi',  'path' = '%s/%s',  'table.type' = 'COPY_ON_WRITE',  'hive_sync.enable' = 'true',  'hive_sync.mode' = 'hms',  'hive_sync.metastore.uris' = 'thrift://localhost:%s',  'hive_sync.db' = '%s',  'hive_sync.table' = '%s',  'hive_sync.partition_fields' = 'pt',  'hoodie.datasource.write.hive_style_partitioning' = 'true',  'hive_sync.partition_extractor_class' = 'org.apache.hudi.hive.HiveStylePartitionValueExtractor')", tableName, System.getProperty(HiveConf.ConfVars.METASTOREWAREHOUSE.varname), tableName, 9089, dbName, tableName);
        ArrayList<String> insertValues = new ArrayList<String>();
        for (i = 0; i < 50; ++i) {
            insertValues.add(String.format("('%s', '%s', '%s')", i, "A", "2025-01-01"));
        }
        this.sql(tEnv, "INSERT INTO %s VALUES %s", tableName, String.join((CharSequence)",", insertValues));
        insertValues.clear();
        for (i = 0; i < 50; ++i) {
            insertValues.add(String.format("('%s', '%s', '%s')", i, "B", "2025-01-01"));
        }
        this.sql(tEnv, "INSERT INTO %s VALUES %s", tableName, String.join((CharSequence)",", insertValues));
        List<Row> r1 = this.sql(tEnv, "SELECT * FROM %s", tableName);
        this.sql(tEnv, "CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse' = '%s')", this.warehouse);
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE test");
        ((CloneAction)this.createAction(CloneAction.class, new String[]{"clone", "--database", dbName, "--table", tableName, "--catalog_conf", "metastore=hive", "--catalog_conf", "uri=thrift://localhost:9089", "--target_database", "test", "--target_table", "test_table", "--target_catalog_conf", "warehouse=" + this.warehouse})).run();
        List<Row> r2 = this.sql(tEnv, "SELECT * FROM test.test_table", new Object[0]);
        Assertions.assertThatList(r1).containsExactlyInAnyOrderElementsOf(r2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Row> sql(TableEnvironment tEnv, String query, Object ... args) {
        try (CloseableIterator iter = tEnv.executeSql(String.format(query, args)).collect();){
            ImmutableList immutableList = ImmutableList.copyOf((Iterator)iter);
            return immutableList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

