/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import com.klarna.hiverunner.HiveShell;
import com.klarna.hiverunner.annotations.HiveSQL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;
import org.apache.paimon.hive.runner.PaimonEmbeddedHiveRunner;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=PaimonEmbeddedHiveRunner.class)
public abstract class IcebergHiveMetadataCommitterITCaseBase {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @HiveSQL(files={})
    protected static HiveShell hiveShell;
    private String path;

    @Before
    public void before() throws Exception {
        this.path = this.folder.newFolder().toURI().toString();
    }

    @After
    public void after() {
        hiveShell.execute("DROP DATABASE IF EXISTS test_db CASCADE");
        hiveShell.execute("DROP DATABASE IF EXISTS test_db_iceberg CASCADE");
    }

    @Test
    public void testPrimaryKeyTable() throws Exception {
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        tEnv.executeSql("CREATE CATALOG my_paimon WITH ( 'type' = 'paimon', 'warehouse' = '" + this.path + "' )");
        tEnv.executeSql("CREATE DATABASE my_paimon.test_db");
        tEnv.executeSql("CREATE TABLE my_paimon.test_db.t ( pt INT, id INT, data STRING, PRIMARY KEY (pt, id) NOT ENFORCED ) PARTITIONED BY (pt) WITH ( 'metadata.iceberg.storage' = 'hive-catalog', 'metadata.iceberg.uri' = '', 'file.format' = 'avro',  'full-compaction.delta-commits' = '1' )");
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t VALUES (1, 1, 'apple'), (1, 2, 'pear'), (2, 1, 'cat'), (2, 2, 'dog')").await();
        tEnv.executeSql("CREATE CATALOG my_iceberg WITH ( 'type' = 'iceberg', 'catalog-type' = 'hive', 'uri' = '', 'warehouse' = '" + this.path + "', 'cache-enabled' = 'false' )");
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"dog", 2, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db.t WHERE id = 2 ORDER BY pt, id")));
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t VALUES (1, 1, 'cherry'), (2, 2, 'elephant')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{1, 1, "cherry"}), Row.of((Object[])new Object[]{1, 2, "pear"}), Row.of((Object[])new Object[]{2, 1, "cat"}), Row.of((Object[])new Object[]{2, 2, "elephant"})), this.collect(tEnv.executeSql("SELECT * FROM my_iceberg.test_db.t ORDER BY pt, id")));
        tEnv.executeSql("ALTER TABLE my_paimon.test_db.t DROP PARTITION (pt = 1)").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{2, 1, "cat"}), Row.of((Object[])new Object[]{2, 2, "elephant"})), this.collect(tEnv.executeSql("SELECT * FROM my_iceberg.test_db.t ORDER BY pt, id")));
        Assertions.assertTrue((boolean)hiveShell.executeQuery("DESC DATABASE EXTENDED test_db").toString().contains("iceberg/test_db"));
        tEnv.executeSql("CREATE TABLE my_paimon.test_db.t1 ( pt INT, id INT, data STRING, PRIMARY KEY (pt, id) NOT ENFORCED ) PARTITIONED BY (pt) WITH ( 'metadata.iceberg.storage' = 'hive-catalog', 'metadata.iceberg.uri' = '', 'file.format' = 'avro',  'metadata.iceberg.database' = 'test_db_iceberg', 'metadata.iceberg.table' = 't1_iceberg', 'full-compaction.delta-commits' = '1' )");
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t1 VALUES (1, 1, 'apple'), (1, 2, 'pear'), (2, 1, 'cat'), (2, 2, 'dog')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"dog", 2, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db_iceberg.t1_iceberg WHERE id = 2 ORDER BY pt, id")));
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t1 VALUES (1, 1, 'cherry'), (2, 2, 'elephant')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{1, 1, "cherry"}), Row.of((Object[])new Object[]{1, 2, "pear"}), Row.of((Object[])new Object[]{2, 1, "cat"}), Row.of((Object[])new Object[]{2, 2, "elephant"})), this.collect(tEnv.executeSql("SELECT * FROM my_iceberg.test_db_iceberg.t1_iceberg ORDER BY pt, id")));
        Assertions.assertTrue((boolean)hiveShell.executeQuery("DESC DATABASE EXTENDED test_db_iceberg").toString().contains("iceberg/test_db"));
    }

    @Test
    public void testAppendOnlyTable() throws Exception {
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        tEnv.executeSql("CREATE CATALOG my_paimon WITH ( 'type' = 'paimon', 'warehouse' = '" + this.path + "' )");
        tEnv.executeSql("CREATE DATABASE my_paimon.test_db");
        tEnv.executeSql("CREATE TABLE my_paimon.test_db.t ( pt INT, id INT, data STRING ) PARTITIONED BY (pt) WITH ( 'metadata.iceberg.storage' = 'hive-catalog', 'metadata.iceberg.uri' = '', 'file.format' = 'avro', 'metadata.iceberg.hive-skip-update-stats' = 'true', 'metadata.iceberg.glue.skip-archive' = 'true' )");
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t VALUES (1, 1, 'apple'), (1, 2, 'pear'), (2, 1, 'cat'), (2, 2, 'dog')").await();
        tEnv.executeSql("CREATE CATALOG my_iceberg WITH ( 'type' = 'iceberg', 'catalog-type' = 'hive', 'uri' = '', 'warehouse' = '" + this.path + "', 'cache-enabled' = 'false' )");
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"dog", 2, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db.t WHERE id = 2 ORDER BY pt, id")));
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t VALUES (1, 3, 'cherry'), (2, 3, 'elephant')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"cherry", 3, 1}), Row.of((Object[])new Object[]{"dog", 2, 2}), Row.of((Object[])new Object[]{"elephant", 3, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db.t WHERE id > 1 ORDER BY pt, id")));
        tEnv.executeSql("ALTER TABLE my_paimon.test_db.t DROP PARTITION (pt = 2)").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"cherry", 3, 1})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db.t WHERE id > 1 ORDER BY pt, id")));
        tEnv.executeSql("CREATE TABLE my_paimon.test_db.t1 ( pt INT, id INT, data STRING ) PARTITIONED BY (pt) WITH ( 'metadata.iceberg.storage' = 'hive-catalog', 'metadata.iceberg.uri' = '', 'file.format' = 'avro', 'metadata.iceberg.database' = 'test_db_iceberg', 'metadata.iceberg.table' = 't1_iceberg')");
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t1 VALUES (1, 1, 'apple'), (1, 2, 'pear'), (2, 1, 'cat'), (2, 2, 'dog')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"dog", 2, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db_iceberg.t1_iceberg WHERE id = 2 ORDER BY pt, id")));
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t1 VALUES (1, 3, 'cherry'), (2, 3, 'elephant')").await();
        Assertions.assertEquals(Arrays.asList(Row.of((Object[])new Object[]{"pear", 2, 1}), Row.of((Object[])new Object[]{"cherry", 3, 1}), Row.of((Object[])new Object[]{"dog", 2, 2}), Row.of((Object[])new Object[]{"elephant", 3, 2})), this.collect(tEnv.executeSql("SELECT data, id, pt FROM my_iceberg.test_db_iceberg.t1_iceberg WHERE id > 1 ORDER BY pt, id")));
    }

    @Test
    public void testCustomMetastoreClass() {
        TableEnvironmentImpl tEnv = TableEnvironmentImpl.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
        tEnv.executeSql("CREATE CATALOG my_paimon WITH ( 'type' = 'paimon', 'warehouse' = '" + this.path + "' )");
        tEnv.executeSql("CREATE DATABASE my_paimon.test_db");
        tEnv.executeSql(String.format("CREATE TABLE my_paimon.test_db.t ( pt INT, id INT, data STRING ) PARTITIONED BY (pt) WITH ( 'metadata.iceberg.storage' = 'hive-catalog', 'metadata.iceberg.uri' = '', 'file.format' = 'avro', 'metadata.iceberg.hive-skip-update-stats' = 'true', 'metadata.iceberg.hive-client-class' = '%s')", this.createFailHiveMetaStoreClient()));
        Assertions.assertThrows(Exception.class, () -> IcebergHiveMetadataCommitterITCaseBase.lambda$testCustomMetastoreClass$0((TableEnvironment)tEnv));
    }

    protected abstract String createFailHiveMetaStoreClient();

    private List<Row> collect(TableResult result) throws Exception {
        ArrayList<Row> rows = new ArrayList<Row>();
        try (CloseableIterator it = result.collect();){
            while (it.hasNext()) {
                rows.add((Row)it.next());
            }
        }
        return rows;
    }

    private static /* synthetic */ void lambda$testCustomMetastoreClass$0(TableEnvironment tEnv) throws Throwable {
        tEnv.executeSql("INSERT INTO my_paimon.test_db.t VALUES (1, 1, 'apple'), (1, 2, 'pear'), (2, 1, 'cat'), (2, 2, 'dog')").await();
    }
}

