/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.bucket;

import org.apache.paimon.bucket.BucketFunction;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class ModBucketFunction
implements BucketFunction {
    private static final long serialVersionUID = 1L;
    private final DataTypeRoot bucketKeyTypeRoot;

    public ModBucketFunction(RowType bucketKeyType) {
        Preconditions.checkArgument(bucketKeyType.getFieldCount() == 1, "bucket key must have exactly one field in mod bucket function");
        DataTypeRoot bucketKeyTypeRoot = bucketKeyType.getTypeAt(0).getTypeRoot();
        Preconditions.checkArgument(bucketKeyTypeRoot == DataTypeRoot.INTEGER || bucketKeyTypeRoot == DataTypeRoot.BIGINT, "bucket key type must be INT or BIGINT in mod bucket function, but got %s", bucketKeyType.getTypeAt(0));
        this.bucketKeyTypeRoot = bucketKeyTypeRoot;
    }

    @Override
    public int bucket(BinaryRow row, int numBuckets) {
        assert (numBuckets > 0 && row.getRowKind() == RowKind.INSERT && row.getFieldCount() == 1);
        if (this.bucketKeyTypeRoot == DataTypeRoot.INTEGER) {
            return Math.floorMod(row.getInt(0), numBuckets);
        }
        if (this.bucketKeyTypeRoot == DataTypeRoot.BIGINT) {
            return (int)Math.floorMod(row.getLong(0), (long)numBuckets);
        }
        throw new UnsupportedOperationException("bucket key type must be INT or BIGINT");
    }
}

