/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.function;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.function.Function;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.types.DataField;

public class FunctionImpl
implements Function {
    private final Identifier identifier;
    @Nullable
    private final List<DataField> inputParams;
    @Nullable
    private final List<DataField> returnParams;
    private final boolean deterministic;
    private final Map<String, FunctionDefinition> definitions;
    @Nullable
    private final String comment;
    private final Map<String, String> options;

    public FunctionImpl(Identifier identifier, @Nullable List<DataField> inputParams, @Nullable List<DataField> returnParams, boolean deterministic, Map<String, FunctionDefinition> definitions, @Nullable String comment, Map<String, String> options) {
        this.identifier = identifier;
        this.inputParams = inputParams;
        this.returnParams = returnParams;
        this.deterministic = deterministic;
        this.definitions = definitions;
        this.comment = comment;
        this.options = options;
    }

    public FunctionImpl(Identifier identifier, Map<String, FunctionDefinition> definitions) {
        this.identifier = identifier;
        this.inputParams = null;
        this.returnParams = null;
        this.deterministic = true;
        this.definitions = definitions;
        this.comment = null;
        this.options = Collections.emptyMap();
    }

    @Override
    public String name() {
        return this.identifier.getObjectName();
    }

    @Override
    public String fullName() {
        return this.identifier.getFullName();
    }

    @Override
    public Identifier identifier() {
        return this.identifier;
    }

    @Override
    public Optional<List<DataField>> inputParams() {
        return Optional.ofNullable(this.inputParams);
    }

    @Override
    public Optional<List<DataField>> returnParams() {
        return Optional.ofNullable(this.returnParams);
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public Map<String, FunctionDefinition> definitions() {
        return this.definitions;
    }

    @Override
    public FunctionDefinition definition(String name) {
        return this.definitions.get(name);
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImpl function = (FunctionImpl)o;
        return this.deterministic == function.deterministic && Objects.equals(this.identifier, function.identifier) && Objects.equals(this.inputParams, function.inputParams) && Objects.equals(this.returnParams, function.returnParams) && Objects.equals(this.definitions, function.definitions) && Objects.equals(this.comment, function.comment) && Objects.equals(this.options, function.options);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.inputParams, this.returnParams, this.deterministic, this.definitions, this.comment, this.options);
    }
}

