/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.hive.HiveSchema;
import org.apache.paimon.hive.SchemaVisitor;
import org.apache.paimon.hive.objectinspector.HivePaimonArray;
import org.apache.paimon.hive.objectinspector.WriteableObjectInspector;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class HiveDeserializer {
    private final FieldDeserializer fieldDeserializer;

    InternalRow deserialize(Object data) {
        return (InternalRow)this.fieldDeserializer.value(data);
    }

    private HiveDeserializer(HiveSchema schema, ObjectInspectorPair pair) {
        this.fieldDeserializer = DeserializerVisitor.visit(schema, pair);
    }

    private static class ObjectInspectorPair {
        private ObjectInspector writerInspector;
        private ObjectInspector sourceInspector;

        ObjectInspectorPair(ObjectInspector writerInspector, ObjectInspector sourceInspector) {
            this.writerInspector = writerInspector;
            this.sourceInspector = sourceInspector;
        }

        ObjectInspector writerInspector() {
            return this.writerInspector;
        }

        ObjectInspector sourceInspector() {
            return this.sourceInspector;
        }

        String sourceName(String originalName) {
            return originalName;
        }
    }

    private static class SchemaNameMappingObjectInspectorPair
    extends ObjectInspectorPair {
        private final Map<String, String> sourceNameMap;

        SchemaNameMappingObjectInspectorPair(HiveSchema schema, ObjectInspectorPair pair) {
            super(pair.writerInspector(), pair.sourceInspector());
            this.sourceNameMap = Maps.newHashMapWithExpectedSize(schema.fields().size());
            List fields = ((StructObjectInspector)this.sourceInspector()).getAllStructFieldRefs();
            for (int i = 0; i < schema.fields().size(); ++i) {
                this.sourceNameMap.put(schema.fields().get(i).name(), ((StructField)fields.get(i)).getFieldName());
            }
        }

        @Override
        String sourceName(String originalName) {
            return this.sourceNameMap.get(originalName);
        }
    }

    private static interface FieldDeserializer {
        public Object value(Object var1);
    }

    private static class PartnerObjectInspectorByNameAccessors
    implements SchemaVisitor.PartnerAccessors<ObjectInspectorPair> {
        private PartnerObjectInspectorByNameAccessors() {
        }

        @Override
        public ObjectInspectorPair fieldPartner(ObjectInspectorPair pair, String name) {
            String sourceName = pair.sourceName(name);
            return new ObjectInspectorPair(((StructObjectInspector)pair.writerInspector()).getStructFieldRef(name).getFieldObjectInspector(), ((StructObjectInspector)pair.sourceInspector()).getStructFieldRef(sourceName).getFieldObjectInspector());
        }

        @Override
        public ObjectInspectorPair mapKeyPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapKeyObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapKeyObjectInspector());
        }

        @Override
        public ObjectInspectorPair mapValuePartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((MapObjectInspector)pair.writerInspector()).getMapValueObjectInspector(), ((MapObjectInspector)pair.sourceInspector()).getMapValueObjectInspector());
        }

        @Override
        public ObjectInspectorPair listPartner(ObjectInspectorPair pair) {
            return new ObjectInspectorPair(((ListObjectInspector)pair.writerInspector()).getListElementObjectInspector(), ((ListObjectInspector)pair.sourceInspector()).getListElementObjectInspector());
        }
    }

    private static class DeserializerVisitor
    extends SchemaVisitor<ObjectInspectorPair, FieldDeserializer> {
        private DeserializerVisitor() {
        }

        public static FieldDeserializer visit(HiveSchema schema, ObjectInspectorPair pair) {
            return DeserializerVisitor.visit(schema, new SchemaNameMappingObjectInspectorPair(schema, pair), new DeserializerVisitor(), new PartnerObjectInspectorByNameAccessors());
        }

        @Override
        public FieldDeserializer primitive(DataType type, ObjectInspectorPair pair) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ObjectInspector writerFieldInspector = pair.writerInspector();
                ObjectInspector sourceFieldInspector = pair.sourceInspector();
                Object result = ((PrimitiveObjectInspector)sourceFieldInspector).getPrimitiveJavaObject(o);
                if (writerFieldInspector instanceof WriteableObjectInspector) {
                    result = ((WriteableObjectInspector)writerFieldInspector).convert(result);
                }
                return result;
            };
        }

        @Override
        public FieldDeserializer rowType(RowType type, ObjectInspectorPair pair, List<FieldDeserializer> deserializers) {
            Preconditions.checkNotNull(type, "Can not create deserializer for null type");
            return o -> {
                if (o == null) {
                    return null;
                }
                List data = ((StructObjectInspector)pair.sourceInspector()).getStructFieldsDataAsList(o);
                GenericRow row = new GenericRow(data.size());
                for (int i = 0; i < data.size(); ++i) {
                    Object fieldValue = data.get(i);
                    if (fieldValue != null) {
                        row.setField(i, ((FieldDeserializer)deserializers.get(i)).value(fieldValue));
                        continue;
                    }
                    row.setField(i, null);
                }
                return row;
            };
        }

        @Override
        public FieldDeserializer list(ArrayType type, ObjectInspectorPair pair, FieldDeserializer deserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ArrayList<Object> result = Lists.newArrayList();
                ListObjectInspector listInspector = (ListObjectInspector)pair.sourceInspector();
                for (Object val : listInspector.getList(o)) {
                    result.add(deserializer.value(val));
                }
                return new HivePaimonArray(type.getElementType(), result);
            };
        }

        @Override
        public FieldDeserializer map(MapType mapType, ObjectInspectorPair pair, FieldDeserializer keyDeserializer, FieldDeserializer valueDeserializer) {
            return o -> {
                if (o == null) {
                    return null;
                }
                ArrayList<Object> keys = new ArrayList<Object>();
                ArrayList<Object> values = new ArrayList<Object>();
                MapObjectInspector mapObjectInspector = (MapObjectInspector)pair.sourceInspector();
                final Map map = mapObjectInspector.getMap(o);
                for (Map.Entry entry : map.entrySet()) {
                    keys.add(keyDeserializer.value(entry.getKey()));
                    values.add(valueDeserializer.value(entry.getValue()));
                }
                final HivePaimonArray key = new HivePaimonArray(mapType.getKeyType(), keys);
                final HivePaimonArray value = new HivePaimonArray(mapType.getValueType(), values);
                return new InternalMap(){

                    @Override
                    public int size() {
                        return map.size();
                    }

                    @Override
                    public InternalArray keyArray() {
                        return key;
                    }

                    @Override
                    public InternalArray valueArray() {
                        return value;
                    }
                };
            };
        }
    }

    static class Builder {
        private HiveSchema schema;
        private StructObjectInspector writerInspector;
        private StructObjectInspector sourceInspector;

        Builder() {
        }

        Builder schema(HiveSchema mainSchema) {
            this.schema = mainSchema;
            return this;
        }

        Builder writerInspector(StructObjectInspector inspector) {
            this.writerInspector = inspector;
            return this;
        }

        Builder sourceInspector(StructObjectInspector inspector) {
            this.sourceInspector = inspector;
            return this;
        }

        HiveDeserializer build() {
            return new HiveDeserializer(this.schema, new ObjectInspectorPair((ObjectInspector)this.writerInspector, (ObjectInspector)this.sourceInspector));
        }
    }
}

