/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.compact.aggregate.factory;

import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.mergetree.compact.aggregate.FieldNestedUpdateAgg;
import org.apache.paimon.mergetree.compact.aggregate.factory.FieldAggregatorFactory;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class FieldNestedUpdateAggFactory
implements FieldAggregatorFactory {
    public static final String NAME = "nested_update";

    @Override
    public FieldNestedUpdateAgg create(DataType fieldType, CoreOptions options, String field) {
        return this.createFieldNestedUpdateAgg(fieldType, options.fieldNestedUpdateAggNestedKey(field), options.fieldNestedUpdateAggCountLimit(field));
    }

    @Override
    public String identifier() {
        return NAME;
    }

    private FieldNestedUpdateAgg createFieldNestedUpdateAgg(DataType fieldType, List<String> nestedKey, int countLimit) {
        if (nestedKey == null) {
            nestedKey = Collections.emptyList();
        }
        String typeErrorMsg = "Data type for nested table column must be 'Array<Row>' but was '%s'.";
        Preconditions.checkArgument(fieldType instanceof ArrayType, typeErrorMsg, fieldType);
        ArrayType arrayType = (ArrayType)fieldType;
        Preconditions.checkArgument(arrayType.getElementType() instanceof RowType, typeErrorMsg, fieldType);
        return new FieldNestedUpdateAgg(this.identifier(), arrayType, nestedKey, countLimit);
    }
}

