/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.BucketEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.operation.ManifestsReader;
import org.apache.paimon.operation.metrics.ScanMetrics;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.utils.BiFilter;
import org.apache.paimon.utils.Filter;

public interface FileStoreScan {
    public FileStoreScan withPartitionFilter(Predicate var1);

    public FileStoreScan withPartitionFilter(List<BinaryRow> var1);

    public FileStoreScan withPartitionsFilter(List<Map<String, String>> var1);

    public FileStoreScan withPartitionFilter(PartitionPredicate var1);

    public FileStoreScan withBucket(int var1);

    public FileStoreScan onlyReadRealBuckets();

    public FileStoreScan withBucketFilter(Filter<Integer> var1);

    public FileStoreScan withTotalAwareBucketFilter(BiFilter<Integer, Integer> var1);

    public FileStoreScan withPartitionBucket(BinaryRow var1, int var2);

    public FileStoreScan withSnapshot(long var1);

    public FileStoreScan withSnapshot(Snapshot var1);

    public FileStoreScan withKind(ScanMode var1);

    public FileStoreScan withLevel(int var1);

    public FileStoreScan withLevelFilter(Filter<Integer> var1);

    public FileStoreScan withLevelMinMaxFilter(BiFilter<Integer, Integer> var1);

    public FileStoreScan enableValueFilter();

    public FileStoreScan withManifestEntryFilter(Filter<ManifestEntry> var1);

    public FileStoreScan withDataFileNameFilter(Filter<String> var1);

    public FileStoreScan withMetrics(ScanMetrics var1);

    public FileStoreScan dropStats();

    public FileStoreScan keepStats();

    @Nullable
    public Integer parallelism();

    public ManifestsReader manifestsReader();

    public List<ManifestEntry> readManifest(ManifestFileMeta var1);

    public Plan plan();

    default public Long totalRecordCount(Snapshot snapshot) {
        return snapshot.totalRecordCount() == null ? Long.valueOf(ManifestEntry.recordCount(this.withSnapshot(snapshot.id()).plan().files())) : snapshot.totalRecordCount();
    }

    public List<SimpleFileEntry> readSimpleEntries();

    public List<PartitionEntry> readPartitionEntries();

    public List<BucketEntry> readBucketEntries();

    public Iterator<ManifestEntry> readFileIterator();

    default public List<BinaryRow> listPartitions() {
        return this.readPartitionEntries().stream().map(PartitionEntry::partition).collect(Collectors.toList());
    }

    public static interface Plan {
        @Nullable
        public Long watermark();

        @Nullable
        public Snapshot snapshot();

        public List<ManifestEntry> files();

        default public List<ManifestEntry> files(FileKind kind) {
            return this.files().stream().filter(e -> e.kind() == kind).collect(Collectors.toList());
        }

        public static Map<BinaryRow, Map<Integer, List<ManifestEntry>>> groupByPartFiles(List<ManifestEntry> files) {
            LinkedHashMap<BinaryRow, Map<Integer, List<ManifestEntry>>> groupBy = new LinkedHashMap<BinaryRow, Map<Integer, List<ManifestEntry>>>();
            for (ManifestEntry entry : files) {
                groupBy.computeIfAbsent(entry.partition(), k -> new LinkedHashMap()).computeIfAbsent(entry.bucket(), k -> new ArrayList()).add(entry);
            }
            return groupBy;
        }
    }
}

