/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.rest.RESTApi;
import org.apache.paimon.rest.RESTCatalogOptions;
import org.apache.paimon.rest.RESTToken;
import org.apache.paimon.rest.RESTUtil;
import org.apache.paimon.rest.responses.GetTableTokenResponse;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Cache;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.paimon.shade.caffeine2.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableMap;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.utils.IOUtils;
import org.apache.paimon.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTTokenFileIO
implements FileIO {
    private static final long serialVersionUID = 2L;
    public static final ConfigOption<Boolean> DATA_TOKEN_ENABLED = ConfigOptions.key("data-token.enabled").booleanType().defaultValue(false).withDescription("Whether to support data token provided by the REST server.");
    private static final Cache<RESTToken, FileIO> FILE_IO_CACHE = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(1000L).removalListener((ignored, value, cause) -> IOUtils.closeQuietly((FileIO)value)).scheduler(Scheduler.forScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(ThreadUtils.newDaemonThreadFactory("rest-token-file-io-scheduler")))).build();
    private static final Logger LOG = LoggerFactory.getLogger(RESTTokenFileIO.class);
    private final CatalogContext catalogContext;
    private final Identifier identifier;
    private final Path path;
    private volatile transient RESTApi apiInstance;
    private volatile RESTToken token;

    public RESTTokenFileIO(CatalogContext catalogContext, RESTApi apiInstance, Identifier identifier, Path path) {
        this.catalogContext = catalogContext;
        this.apiInstance = apiInstance;
        this.identifier = identifier;
        this.path = path;
    }

    @Override
    public void configure(CatalogContext context) {
        throw new UnsupportedOperationException("RESTTokenFileIO does not support configuration.");
    }

    @Override
    public SeekableInputStream newInputStream(Path path) throws IOException {
        return this.fileIO().newInputStream(path);
    }

    @Override
    public PositionOutputStream newOutputStream(Path path, boolean overwrite) throws IOException {
        return this.fileIO().newOutputStream(path, overwrite);
    }

    @Override
    public FileStatus getFileStatus(Path path) throws IOException {
        return this.fileIO().getFileStatus(path);
    }

    @Override
    public FileStatus[] listStatus(Path path) throws IOException {
        return this.fileIO().listStatus(path);
    }

    @Override
    public boolean exists(Path path) throws IOException {
        return this.fileIO().exists(path);
    }

    @Override
    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.fileIO().delete(path, recursive);
    }

    @Override
    public boolean mkdirs(Path path) throws IOException {
        return this.fileIO().mkdirs(path);
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.fileIO().rename(src, dst);
    }

    @Override
    public boolean isObjectStore() {
        try {
            return this.fileIO().isObjectStore();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileIO fileIO() throws IOException {
        this.tryToRefreshToken();
        FileIO fileIO = FILE_IO_CACHE.getIfPresent(this.token);
        if (fileIO != null) {
            return fileIO;
        }
        Cache<RESTToken, FileIO> cache = FILE_IO_CACHE;
        synchronized (cache) {
            fileIO = FILE_IO_CACHE.getIfPresent(this.token);
            if (fileIO != null) {
                return fileIO;
            }
            Options options = this.catalogContext.options();
            options = new Options(RESTTokenFileIO.mergeTokenWithDlfEndpointHandling(options.toMap(), this.token.token()));
            options.set(CatalogOptions.FILE_IO_ALLOW_CACHE, false);
            CatalogContext context = CatalogContext.create(options, this.catalogContext.hadoopConf(), this.catalogContext.preferIO(), this.catalogContext.fallbackIO());
            try {
                fileIO = FileIO.get(this.path, context);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            FILE_IO_CACHE.put(this.token, fileIO);
            return fileIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToRefreshToken() {
        if (this.shouldRefresh()) {
            RESTTokenFileIO rESTTokenFileIO = this;
            synchronized (rESTTokenFileIO) {
                if (this.shouldRefresh()) {
                    this.refreshToken();
                }
            }
        }
    }

    private boolean shouldRefresh() {
        return this.token == null || this.token.expireAtMillis() - System.currentTimeMillis() < 3600000L;
    }

    private void refreshToken() {
        LOG.info("begin refresh data token for identifier [{}]", (Object)this.identifier);
        if (this.apiInstance == null) {
            this.apiInstance = new RESTApi(this.catalogContext.options(), false);
        }
        Identifier tableIdentifier = this.identifier;
        if (this.identifier.isSystemTable()) {
            tableIdentifier = new Identifier(this.identifier.getDatabaseName(), this.identifier.getTableName(), this.identifier.getBranchName());
        }
        GetTableTokenResponse response = this.apiInstance.loadTableToken(tableIdentifier);
        LOG.info("end refresh data token for identifier [{}] expiresAtMillis [{}]", (Object)this.identifier, (Object)response.getExpiresAtMillis());
        this.token = new RESTToken(response.getToken(), response.getExpiresAtMillis());
    }

    public static Map<String, String> mergeTokenWithDlfEndpointHandling(Map<String, String> catalogProperties, Map<String, String> restTokenProperties) {
        LinkedHashMap<String, String> result = Maps.newLinkedHashMap(RESTUtil.merge(catalogProperties, restTokenProperties));
        String dlfOssEndpoint = (String)result.get(RESTCatalogOptions.DLF_OSS_ENDPOINT.key());
        if (dlfOssEndpoint != null && !dlfOssEndpoint.isEmpty()) {
            result.put("fs.oss.endpoint", dlfOssEndpoint);
        }
        return ImmutableMap.copyOf(result);
    }

    public RESTToken validToken() {
        this.tryToRefreshToken();
        return this.token;
    }
}

