/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.org.apache.datasketches.memory.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.NioBitsFields;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.UnsafeUtil;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.Util;
import org.apache.paimon.shade.org.apache.datasketches.memory.internal.VirtualMachineMemory;

final class NioBits {
    private static final Class<?> NIO_BITS_CLASS;
    private static final Method NIO_BITS_RESERVE_MEMORY_METHOD;
    private static final Method NIO_BITS_UNRESERVE_MEMORY_METHOD;
    private static final AtomicLong nioBitsCount;
    private static final AtomicLong nioBitsReservedMemory;
    private static final AtomicLong nioBitsTotalCapacity;
    private static int pageSize;
    private static final long maxDBBMemory;
    private static final boolean isPageAligned;

    private NioBits() {
    }

    static long getDirectAllocationsCount() {
        return nioBitsCount.get();
    }

    static long getReservedMemory() {
        return nioBitsReservedMemory.get();
    }

    static long getTotalCapacity() {
        return nioBitsTotalCapacity.get();
    }

    static int pageSize() {
        return pageSize;
    }

    static int pageCount(long bytes) {
        return (int)(bytes + (long)NioBits.pageSize() - 1L) / NioBits.pageSize();
    }

    static long getMaxDirectByteBufferMemory() {
        return maxDBBMemory;
    }

    static boolean isPageAligned() {
        return isPageAligned;
    }

    static void reserveMemory(long allocationSize, long capacity) {
        NioBits.reserveUnreserve(allocationSize, capacity, NIO_BITS_RESERVE_MEMORY_METHOD);
    }

    static void unreserveMemory(long allocationSize, long capacity) {
        NioBits.reserveUnreserve(allocationSize, capacity, NIO_BITS_UNRESERVE_MEMORY_METHOD);
    }

    private static void reserveUnreserve(long allocationSize, long capacity, Method method) {
        Util.zeroCheck(capacity, "capacity");
        long chunkSizeLimit = 0x40000000L;
        try {
            while (capacity > 0L) {
                long chunk = Math.min(capacity, 0x40000000L);
                if (capacity == chunk) {
                    method.invoke(null, allocationSize, (int)capacity);
                } else {
                    method.invoke(null, chunk, (int)chunk);
                }
                capacity -= chunk;
                allocationSize -= chunk;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException("Could not invoke java.nio.Bits.unreserveMemory(...) OR java.nio.Bits.reserveMemory(...): allocationSize = " + allocationSize + ", capacity = " + capacity, e);
        }
    }

    static {
        pageSize = UnsafeUtil.unsafe.pageSize();
        try {
            isPageAligned = VirtualMachineMemory.getIsPageAligned();
            maxDBBMemory = VirtualMachineMemory.getMaxDBBMemory();
            NIO_BITS_CLASS = Class.forName("java.nio.Bits");
            NIO_BITS_RESERVE_MEMORY_METHOD = NIO_BITS_CLASS.getDeclaredMethod("reserveMemory", Long.TYPE, Integer.TYPE);
            NIO_BITS_RESERVE_MEMORY_METHOD.setAccessible(true);
            NIO_BITS_UNRESERVE_MEMORY_METHOD = NIO_BITS_CLASS.getDeclaredMethod("unreserveMemory", Long.TYPE, Integer.TYPE);
            NIO_BITS_UNRESERVE_MEMORY_METHOD.setAccessible(true);
            Field countField = NIO_BITS_CLASS.getDeclaredField(NioBitsFields.COUNT_FIELD_NAME);
            countField.setAccessible(true);
            nioBitsCount = (AtomicLong)countField.get(null);
            Field reservedMemoryField = NIO_BITS_CLASS.getDeclaredField(NioBitsFields.RESERVED_MEMORY_FIELD_NAME);
            reservedMemoryField.setAccessible(true);
            nioBitsReservedMemory = (AtomicLong)reservedMemoryField.get(null);
            Field totalCapacityField = NIO_BITS_CLASS.getDeclaredField(NioBitsFields.TOTAL_CAPACITY_FIELD_NAME);
            totalCapacityField.setAccessible(true);
            nioBitsTotalCapacity = (AtomicLong)totalCapacityField.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException("Could not acquire java.nio.Bits class: " + e.getClass());
        }
    }
}

