/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.oss;

import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PluginFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.plugin.PluginLoader;

public class OSSLoader
implements FileIOLoader {
    private static final String OSS_JAR = "paimon-plugin-oss.jar";
    private static final String OSS_CLASS = "org.apache.paimon.oss.OSSFileIO";
    private static PluginLoader loader;

    private static synchronized PluginLoader getLoader() {
        if (loader == null) {
            loader = new PluginLoader(OSS_JAR);
        }
        return loader;
    }

    public String getScheme() {
        return "oss";
    }

    public FileIO load(Path path) {
        return new OSSPluginFileIO();
    }

    private static class OSSPluginFileIO
    extends PluginFileIO {
        private static final long serialVersionUID = 1L;

        private OSSPluginFileIO() {
        }

        public boolean isObjectStore() {
            return true;
        }

        protected FileIO createFileIO(Path path) {
            FileIO fileIO = (FileIO)OSSLoader.getLoader().newInstance(OSSLoader.OSS_CLASS);
            fileIO.configure(CatalogContext.create((Options)this.options));
            return fileIO;
        }

        protected ClassLoader pluginClassLoader() {
            return OSSLoader.getLoader().submoduleClassLoader();
        }
    }
}

