/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.s3;

import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileIOLoader;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.PluginFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.plugin.PluginLoader;

public class S3Loader
implements FileIOLoader {
    private static final String S3_JAR = "paimon-plugin-s3.jar";
    private static final String S3_CLASS = "org.apache.paimon.s3.S3FileIO";
    private static PluginLoader loader;

    private static synchronized PluginLoader getLoader() {
        if (loader == null) {
            loader = new PluginLoader(S3_JAR);
        }
        return loader;
    }

    public String getScheme() {
        return "s3";
    }

    public FileIO load(Path path) {
        return new S3PluginFileIO();
    }

    private static class S3PluginFileIO
    extends PluginFileIO {
        private static final long serialVersionUID = 1L;

        private S3PluginFileIO() {
        }

        public boolean isObjectStore() {
            return true;
        }

        protected FileIO createFileIO(Path path) {
            FileIO fileIO = (FileIO)S3Loader.getLoader().newInstance(S3Loader.S3_CLASS);
            fileIO.configure(CatalogContext.create((Options)this.options));
            return fileIO;
        }

        protected ClassLoader pluginClassLoader() {
            return S3Loader.getLoader().submoduleClassLoader();
        }
    }
}

