/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.dockerjava.api.command.InspectContainerResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.paimon.utils.Preconditions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.utility.Base58;

public class MinioTestContainer
extends GenericContainer<MinioTestContainer>
implements BeforeAllCallback,
AfterAllCallback {
    private static final String PAIMON_CONFIG_S3_ENDPOINT = "s3.endpoint";
    private static final int DEFAULT_PORT = 9000;
    private static final String MINIO_ACCESS_KEY = "MINIO_ROOT_USER";
    private static final String MINIO_SECRET_KEY = "MINIO_ROOT_PASSWORD";
    private static final String DEFAULT_STORAGE_DIRECTORY = "/data";
    private static final String HEALTH_ENDPOINT = "/minio/health/ready";
    private final String accessKey = MinioTestContainer.randomString("accessKey", 10);
    private final String secretKey = MinioTestContainer.randomString("secret", 10);
    private final String defaultBucketName;

    public MinioTestContainer() {
        this(MinioTestContainer.randomString("bucket", 6));
    }

    public MinioTestContainer(String defaultBucketName) {
        super("minio/minio:RELEASE.2022-02-07T08-17-33Z");
        this.defaultBucketName = (String)Preconditions.checkNotNull((Object)defaultBucketName);
        this.withNetworkAliases(new String[]{MinioTestContainer.randomString("minio", 6)});
        this.addExposedPort(9000);
        this.withEnv(MINIO_ACCESS_KEY, this.accessKey);
        this.withEnv(MINIO_SECRET_KEY, this.secretKey);
        this.withCommand(new String[]{"server", DEFAULT_STORAGE_DIRECTORY});
        this.setWaitStrategy(new HttpWaitStrategy().forPort(9000).forPath(HEALTH_ENDPOINT).withStartupTimeout(Duration.ofMinutes(2L)));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        this.createDefaultBucket();
    }

    private static String randomString(String prefix, int length) {
        return String.format("%s-%s", prefix, Base58.randomString((int)length).toLowerCase(Locale.ROOT));
    }

    private AmazonS3 getClient() {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey)))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getHttpEndpoint(), "unused-region"))).build();
    }

    private String getHttpEndpoint() {
        return String.format("http://%s:%s", this.getHost(), this.getMappedPort(9000));
    }

    public Map<String, String> getS3ConfigOptions() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(PAIMON_CONFIG_S3_ENDPOINT, this.getHttpEndpoint());
        config.put("s3.path.style.access", "true");
        config.put("s3.access.key", this.accessKey);
        config.put("s3.secret.key", this.secretKey);
        return config;
    }

    private void createDefaultBucket() {
        this.getClient().createBucket(this.defaultBucketName);
    }

    public String getS3UriForDefaultBucket() {
        return "s3://" + this.defaultBucketName;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        super.close();
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.start();
    }
}

