/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class IndexManifestEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final IndexFileMeta indexFile;

    public IndexManifestEntry(FileKind kind, BinaryRow partition, int bucket, IndexFileMeta indexFile) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.indexFile = indexFile;
    }

    public IndexManifestEntry toDeleteEntry() {
        Preconditions.checkArgument(this.kind == FileKind.ADD);
        return new IndexManifestEntry(FileKind.DELETE, this.partition, this.bucket, this.indexFile);
    }

    public FileKind kind() {
        return this.kind;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public int bucket() {
        return this.bucket;
    }

    public IndexFileMeta indexFile() {
        return this.indexFile;
    }

    public static RowType schema() {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(0, "_KIND", new TinyIntType(false)));
        fields.add(new DataField(1, "_PARTITION", SerializationUtils.newBytesType(false)));
        fields.add(new DataField(2, "_BUCKET", new IntType(false)));
        fields.add(new DataField(3, "_INDEX_TYPE", SerializationUtils.newStringType(false)));
        fields.add(new DataField(4, "_FILE_NAME", SerializationUtils.newStringType(false)));
        fields.add(new DataField(5, "_FILE_SIZE", new BigIntType(false)));
        fields.add(new DataField(6, "_ROW_COUNT", new BigIntType(false)));
        fields.add(new DataField(7, "_DELETIONS_VECTORS_RANGES", new ArrayType(true, RowType.of(SerializationUtils.newStringType(false), new IntType(false), new IntType(false)))));
        return new RowType(fields);
    }

    public Identifier identifier() {
        return new Identifier(this.partition, this.bucket, this.indexFile.indexType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexManifestEntry entry = (IndexManifestEntry)o;
        return this.bucket == entry.bucket && this.kind == entry.kind && Objects.equals(this.partition, entry.partition) && Objects.equals(this.indexFile, entry.indexFile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.indexFile});
    }

    public String toString() {
        return "IndexManifestEntry{kind=" + (Object)((Object)this.kind) + ", partition=" + this.partition + ", bucket=" + this.bucket + ", indexFile=" + this.indexFile + '}';
    }

    public static class Identifier {
        public final BinaryRow partition;
        public final int bucket;
        public final String indexType;
        private Integer hash;

        private Identifier(BinaryRow partition, int bucket, String indexType) {
            this.partition = partition;
            this.bucket = bucket;
            this.indexType = indexType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.bucket == that.bucket && Objects.equals(this.partition, that.partition) && Objects.equals(this.indexType, that.indexType);
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = Objects.hash(this.partition, this.bucket, this.indexType);
            }
            return this.hash;
        }

        public String toString() {
            return "Identifier{partition=" + this.partition + ", bucket=" + this.bucket + ", indexType='" + this.indexType + '\'' + '}';
        }
    }
}

