/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.metrics;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.metrics.Counter;
import org.apache.paimon.metrics.DescriptiveStatisticsHistogram;
import org.apache.paimon.metrics.Gauge;
import org.apache.paimon.metrics.Histogram;
import org.apache.paimon.metrics.Metric;
import org.apache.paimon.metrics.MetricGroup;
import org.apache.paimon.metrics.SimpleCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricGroupImpl
implements MetricGroup {
    private static final Logger LOG = LoggerFactory.getLogger(MetricGroupImpl.class);
    private final String groupName;
    private final Map<String, String> variables;
    private final Map<String, Metric> metrics;

    public MetricGroupImpl(String groupName) {
        this(groupName, new HashMap<String, String>());
    }

    public MetricGroupImpl(String groupName, Map<String, String> variables) {
        this.groupName = groupName;
        this.variables = variables;
        this.metrics = new HashMap<String, Metric>();
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public Map<String, String> getAllVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    @Override
    public Counter counter(String name) {
        return (Counter)this.addMetric(name, new SimpleCounter());
    }

    @Override
    public <T> Gauge<T> gauge(String name, Gauge<T> gauge) {
        return (Gauge)this.addMetric(name, gauge);
    }

    @Override
    public Histogram histogram(String name, int windowSize) {
        return (Histogram)this.addMetric(name, new DescriptiveStatisticsHistogram(windowSize));
    }

    private Metric addMetric(String metricName, Metric metric) {
        if (metric == null) {
            LOG.warn("Ignoring attempted registration of a metric due to being null for name {}.", (Object)metricName);
            return null;
        }
        switch (metric.getMetricType()) {
            case COUNTER: 
            case GAUGE: 
            case HISTOGRAM: {
                Metric prior = this.metrics.put(metricName, metric);
                if (prior == null) break;
                this.metrics.put(metricName, prior);
                LOG.warn("Name collision: Group already contains a Metric with the name '" + metricName + "'. The new added Metric will not be reported.");
                break;
            }
            default: {
                LOG.warn("Cannot add unknown metric type {}. This indicates that the paimon does not support this metric type.", (Object)metric.getClass().getName());
            }
        }
        return this.metrics.get(metricName);
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }

    @Override
    public void close() {
    }
}

