/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFileMetaSerializer;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.DataTable;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.StreamDataTableScan;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.VarCharType;
import org.apache.paimon.utils.BranchManager;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SimpleFileReader;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.TagManager;

public class BucketsTable
implements DataTable,
ReadonlyTable {
    private static final long serialVersionUID = 1L;
    private final FileStoreTable wrapped;
    private final boolean isContinuous;
    @Nullable
    private final String databaseName;
    private static final RowType ROW_TYPE = RowType.of(new DataType[]{new BigIntType(false), SerializationUtils.newBytesType(false), new IntType(false), SerializationUtils.newBytesType(false), new VarCharType(true, Integer.MAX_VALUE), new VarCharType(false, Integer.MAX_VALUE)}, new String[]{"_SNAPSHOT_ID", "_PARTITION", "_BUCKET", "_FILES", "_DATABASE_NAME", "_TABLE_NAME"});

    public BucketsTable(FileStoreTable wrapped, boolean isContinuous) {
        this(wrapped, isContinuous, null);
    }

    public BucketsTable(FileStoreTable wrapped, boolean isContinuous, String databaseName) {
        this.wrapped = wrapped;
        this.isContinuous = isContinuous;
        this.databaseName = databaseName;
    }

    @Override
    public OptionalLong latestSnapshotId() {
        return this.wrapped.latestSnapshotId();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.wrapped.snapshot(snapshotId);
    }

    @Override
    public SimpleFileReader<ManifestFileMeta> manifestListReader() {
        return this.wrapped.manifestListReader();
    }

    @Override
    public SimpleFileReader<ManifestEntry> manifestFileReader() {
        return this.wrapped.manifestFileReader();
    }

    @Override
    public SimpleFileReader<IndexManifestEntry> indexManifestFileReader() {
        return this.wrapped.indexManifestFileReader();
    }

    @Override
    public Path location() {
        return this.wrapped.location();
    }

    @Override
    public SnapshotManager snapshotManager() {
        return this.wrapped.snapshotManager();
    }

    @Override
    public TagManager tagManager() {
        return this.wrapped.tagManager();
    }

    @Override
    public BranchManager branchManager() {
        return this.wrapped.branchManager();
    }

    @Override
    public DataTable switchToBranch(String branchName) {
        return new BucketsTable(this.wrapped.switchToBranch(branchName), this.isContinuous, this.databaseName);
    }

    @Override
    public String name() {
        return "__internal_buckets_" + this.wrapped.location().getName();
    }

    @Override
    public RowType rowType() {
        return ROW_TYPE;
    }

    @Override
    public Map<String, String> options() {
        return this.wrapped.options();
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.emptyList();
    }

    @Override
    public SnapshotReader newSnapshotReader() {
        return this.wrapped.newSnapshotReader();
    }

    @Override
    public DataTableScan newScan() {
        return this.wrapped.newScan();
    }

    @Override
    public StreamDataTableScan newStreamScan() {
        return this.wrapped.newStreamScan();
    }

    @Override
    public CoreOptions coreOptions() {
        return this.wrapped.coreOptions();
    }

    @Override
    public InnerTableRead newRead() {
        return new BucketsRead();
    }

    @Override
    public BucketsTable copy(Map<String, String> dynamicOptions) {
        return new BucketsTable((FileStoreTable)this.wrapped.copy((Map)dynamicOptions), this.isContinuous, this.databaseName);
    }

    @Override
    public FileIO fileIO() {
        return this.wrapped.fileIO();
    }

    public static RowType getRowType() {
        return ROW_TYPE;
    }

    private class BucketsRead
    implements InnerTableRead {
        private final DataFileMetaSerializer dataFileMetaSerializer = new DataFileMetaSerializer();

        private BucketsRead() {
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            throw new UnsupportedOperationException("BucketsRead does not support projection");
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof DataSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            DataSplit dataSplit = (DataSplit)split;
            List<Object> files = Collections.emptyList();
            if (BucketsTable.this.isContinuous) {
                files = dataSplit.dataFiles();
            }
            GenericRow row = GenericRow.of(dataSplit.snapshotId(), SerializationUtils.serializeBinaryRow(dataSplit.partition()), dataSplit.bucket(), this.dataFileMetaSerializer.serializeList(files), BinaryString.fromString(BucketsTable.this.databaseName), BinaryString.fromString(BucketsTable.this.wrapped.name()));
            return new IteratorRecordReader<InternalRow>(Collections.singletonList(row).iterator());
        }
    }
}

