/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.catalog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.TableType;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogLockContext;
import org.apache.paimon.catalog.CatalogLockFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.catalog.TableMetadata;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.table.CatalogEnvironment;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.FormatTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.object.ObjectTable;
import org.apache.paimon.table.system.AllTableOptionsTable;
import org.apache.paimon.table.system.CatalogOptionsTable;
import org.apache.paimon.table.system.SystemTableLoader;
import org.apache.paimon.utils.InternalRowPartitionComputer;
import org.apache.paimon.utils.Preconditions;

public class CatalogUtils {
    public static Path path(String warehouse, String database, String table) {
        return new Path(String.format("%s/%s.db/%s", warehouse, database, table));
    }

    public static String stringifyPath(String warehouse, String database, String table) {
        return String.format("%s/%s.db/%s", warehouse, database, table);
    }

    public static String warehouse(String path) {
        return new Path(path).getParent().getParent().toString();
    }

    public static String database(Path path) {
        return SchemaManager.identifierFromPath(path.toString(), false).getDatabaseName();
    }

    public static String database(String path) {
        return SchemaManager.identifierFromPath(path, false).getDatabaseName();
    }

    public static String table(Path path) {
        return SchemaManager.identifierFromPath(path.toString(), false).getObjectName();
    }

    public static String table(String path) {
        return SchemaManager.identifierFromPath(path, false).getObjectName();
    }

    public static Map<String, String> tableDefaultOptions(Map<String, String> options) {
        return OptionsUtils.convertToPropertiesPrefixKey(options, "table-default.");
    }

    public static boolean isSystemDatabase(String database) {
        return "sys".equals(database);
    }

    public static void checkNotSystemDatabase(String database) {
        if (CatalogUtils.isSystemDatabase(database)) {
            throw new Catalog.ProcessSystemDatabaseException();
        }
    }

    public static boolean isTableInSystemDatabase(Identifier identifier) {
        return CatalogUtils.isSystemDatabase(identifier.getDatabaseName()) || identifier.isSystemTable();
    }

    public static void checkNotSystemTable(Identifier identifier, String method) {
        if (CatalogUtils.isTableInSystemDatabase(identifier)) {
            throw new IllegalArgumentException(String.format("Cannot '%s' for system table '%s', please use data table.", method, identifier));
        }
    }

    public static void checkNotBranch(Identifier identifier, String method) {
        if (identifier.getBranchName() != null) {
            throw new IllegalArgumentException(String.format("Cannot '%s' for branch table '%s', please modify the table with the default branch.", method, identifier));
        }
    }

    public static void validateAutoCreateClose(Map<String, String> options) {
        Preconditions.checkArgument(!Boolean.parseBoolean(options.getOrDefault(CoreOptions.AUTO_CREATE.key(), CoreOptions.AUTO_CREATE.defaultValue().toString())), String.format("The value of %s property should be %s.", CoreOptions.AUTO_CREATE.key(), Boolean.FALSE));
    }

    public static List<Partition> listPartitionsFromFileSystem(Table table) {
        Options options = Options.fromMap(table.options());
        InternalRowPartitionComputer computer = new InternalRowPartitionComputer(options.get(CoreOptions.PARTITION_DEFAULT_NAME), table.rowType().project(table.partitionKeys()), table.partitionKeys().toArray(new String[0]), options.get(CoreOptions.PARTITION_GENERATE_LEGCY_NAME));
        List<PartitionEntry> partitionEntries = table.newReadBuilder().newScan().listPartitionEntries();
        ArrayList<Partition> partitions = new ArrayList<Partition>(partitionEntries.size());
        for (PartitionEntry entry : partitionEntries) {
            partitions.add(entry.toPartition(computer));
        }
        return partitions;
    }

    public static Table loadTable(Catalog catalog, Identifier identifier, Function<Path, FileIO> internalFileIO, Function<Path, FileIO> externalFileIO, TableMetadata.Loader metadataLoader, @Nullable CatalogLockFactory lockFactory, @Nullable CatalogLockContext lockContext) throws Catalog.TableNotExistException {
        Function<Path, FileIO> dataFileIO;
        if ("sys".equals(identifier.getDatabaseName())) {
            return CatalogUtils.createGlobalSystemTable(identifier.getTableName(), catalog);
        }
        TableMetadata metadata = metadataLoader.load(identifier);
        TableSchema schema = metadata.schema();
        CoreOptions options = CoreOptions.fromMap(schema.options());
        Function<Path, FileIO> function = dataFileIO = metadata.isExternal() ? externalFileIO : internalFileIO;
        if (options.type() == TableType.FORMAT_TABLE) {
            return CatalogUtils.toFormatTable(identifier, schema, dataFileIO);
        }
        CatalogEnvironment catalogEnv = new CatalogEnvironment(identifier, metadata.uuid(), catalog.catalogLoader(), lockFactory, lockContext, catalog.supportsVersionManagement());
        Path path = new Path(schema.options().get(CoreOptions.PATH.key()));
        FileStoreTable table = FileStoreTableFactory.create(dataFileIO.apply(path), path, schema, catalogEnv);
        if (options.type() == TableType.OBJECT_TABLE) {
            table = CatalogUtils.toObjectTable(externalFileIO, table);
        }
        if (identifier.isSystemTable()) {
            return CatalogUtils.createSystemTable(identifier, table);
        }
        return table;
    }

    private static Table createGlobalSystemTable(String tableName, Catalog catalog) throws Catalog.TableNotExistException {
        switch (tableName.toLowerCase()) {
            case "all_table_options": {
                try {
                    HashMap<Identifier, Map<String, String>> allOptions = new HashMap<Identifier, Map<String, String>>();
                    for (String database : catalog.listDatabases()) {
                        for (String name : catalog.listTables(database)) {
                            Identifier identifier = Identifier.create(database, name);
                            Table table = catalog.getTable(identifier);
                            allOptions.put(identifier, table.options());
                        }
                    }
                    return new AllTableOptionsTable(allOptions);
                }
                catch (Catalog.DatabaseNotExistException | Catalog.TableNotExistException e) {
                    throw new RuntimeException("Database is deleted while listing", e);
                }
            }
            case "catalog_options": {
                return new CatalogOptionsTable(Options.fromMap(catalog.options()));
            }
        }
        throw new Catalog.TableNotExistException(Identifier.create("sys", tableName));
    }

    private static Table createSystemTable(Identifier identifier, Table originTable) throws Catalog.TableNotExistException {
        if (!(originTable instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only data table support system tables, but this table %s is %s.", identifier, originTable.getClass()));
        }
        Table table = SystemTableLoader.load(Preconditions.checkNotNull(identifier.getSystemTableName()), (FileStoreTable)originTable);
        if (table == null) {
            throw new Catalog.TableNotExistException(identifier);
        }
        return table;
    }

    private static FormatTable toFormatTable(Identifier identifier, TableSchema schema, Function<Path, FileIO> fileIO) {
        Map<String, String> options = schema.options();
        FormatTable.Format format = FormatTable.parseFormat(options.getOrDefault(CoreOptions.FILE_FORMAT.key(), CoreOptions.FILE_FORMAT.defaultValue()));
        String location = options.get(CoreOptions.PATH.key());
        return FormatTable.builder().fileIO(fileIO.apply(new Path(location))).identifier(identifier).rowType(schema.logicalRowType()).partitionKeys(schema.partitionKeys()).location(location).format(format).options(options).comment(schema.comment()).build();
    }

    private static ObjectTable toObjectTable(Function<Path, FileIO> fileIOLoader, FileStoreTable underlyingTable) {
        CoreOptions options = underlyingTable.coreOptions();
        String objectLocation = options.objectLocation();
        FileIO objectFileIO = fileIOLoader.apply(new Path(objectLocation));
        return ObjectTable.builder().underlyingTable(underlyingTable).objectLocation(objectLocation).objectFileIO(objectFileIO).build();
    }
}

