/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg;

import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.client.ClientPool;
import org.apache.paimon.fs.Path;
import org.apache.paimon.hive.HiveCatalog;
import org.apache.paimon.hive.HiveTypeUtils;
import org.apache.paimon.hive.pool.CachedClientPool;
import org.apache.paimon.iceberg.IcebergCommitCallback;
import org.apache.paimon.iceberg.IcebergMetadataCommitter;
import org.apache.paimon.iceberg.IcebergOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.DataField;
import org.apache.paimon.utils.Preconditions;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergHiveMetadataCommitter
implements IcebergMetadataCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergHiveMetadataCommitter.class);
    private final FileStoreTable table;
    private final Identifier identifier;
    private final ClientPool<IMetaStoreClient, TException> clients;
    private final String icebergHiveDatabase;
    private final String icebergHiveTable;

    public IcebergHiveMetadataCommitter(FileStoreTable table) {
        this.table = table;
        this.identifier = Preconditions.checkNotNull(table.catalogEnvironment().identifier(), "If you want to sync Paimon Iceberg compatible metadata to Hive, you must use a Paimon table created from a Paimon catalog, instead of a temporary table.");
        Preconditions.checkArgument(this.identifier.getBranchName() == null, "Paimon Iceberg compatibility currently does not support branches.");
        Options options = new Options(table.options());
        String uri = options.get(IcebergOptions.URI);
        String hiveConfDir = options.get(IcebergOptions.HIVE_CONF_DIR);
        String hadoopConfDir = options.get(IcebergOptions.HADOOP_CONF_DIR);
        String icebergDatabase = options.get(IcebergOptions.METASTORE_DATABASE);
        String icebergTable = options.get(IcebergOptions.METASTORE_TABLE);
        Configuration hadoopConf = new Configuration();
        hadoopConf.setClassLoader(IcebergHiveMetadataCommitter.class.getClassLoader());
        HiveConf hiveConf = HiveCatalog.createHiveConf(hiveConfDir, hadoopConfDir, hadoopConf);
        table.options().forEach((arg_0, arg_1) -> ((HiveConf)hiveConf).set(arg_0, arg_1));
        if (uri != null) {
            hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, uri);
        }
        if (hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname) == null) {
            LOG.error("Can't find hive metastore uri to connect: either set {} for paimon table or set hive.metastore.uris in hive-site.xml or hadoop configurations. Will use empty metastore uris, which means we may use a embedded metastore. This may cause unpredictable consensus problem.", (Object)IcebergOptions.URI.key());
        }
        this.icebergHiveDatabase = icebergDatabase != null && !icebergDatabase.isEmpty() ? icebergDatabase : this.identifier.getDatabaseName();
        this.icebergHiveTable = icebergTable != null && !icebergTable.isEmpty() ? icebergTable : this.identifier.getTableName();
        this.clients = new CachedClientPool((Configuration)hiveConf, options, options.getString(IcebergOptions.HIVE_CLIENT_CLASS));
    }

    @Override
    public void commitMetadata(Path newMetadataPath, @Nullable Path baseMetadataPath) {
        try {
            this.commitMetadataImpl(newMetadataPath, baseMetadataPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void commitMetadataImpl(Path newMetadataPath, @Nullable Path baseMetadataPath) throws Exception {
        if (!this.databaseExists(this.icebergHiveDatabase)) {
            this.createDatabase(this.icebergHiveDatabase);
        }
        Table hiveTable = this.tableExists() ? this.clients.run(client -> client.getTable(this.icebergHiveDatabase, this.icebergHiveTable)) : this.createTable(newMetadataPath);
        hiveTable.getParameters().put("metadata_location", newMetadataPath.toString());
        if (baseMetadataPath != null) {
            hiveTable.getParameters().put("previous_metadata_location", baseMetadataPath.toString());
        }
        Options options = new Options(this.table.options());
        boolean skipAWSGlueArchive = options.get(IcebergOptions.GLUE_SKIP_ARCHIVE);
        EnvironmentContext environmentContext = new EnvironmentContext();
        environmentContext.putToProperties("CASCADE", "true");
        environmentContext.putToProperties("skipAWSGlueArchive", Boolean.toString(skipAWSGlueArchive));
        this.clients.execute(client -> client.alter_table_with_environmentContext(this.icebergHiveDatabase, this.icebergHiveTable, hiveTable, environmentContext));
    }

    private boolean databaseExists(String databaseName) throws Exception {
        try {
            this.clients.run(client -> client.getDatabase(databaseName));
            return true;
        }
        catch (NoSuchObjectException ignore) {
            return false;
        }
    }

    private void createDatabase(String databaseName) throws Exception {
        Database database = new Database();
        database.setName(databaseName);
        database.setLocationUri(IcebergCommitCallback.catalogDatabasePath(this.table).toString());
        this.clients.execute(client -> client.createDatabase(database));
    }

    private boolean tableExists() throws Exception {
        return this.clients.run(client -> client.tableExists(this.icebergHiveDatabase, this.icebergHiveTable));
    }

    private Table createTable(Path metadataPath) throws Exception {
        long currentTimeMillis = System.currentTimeMillis();
        Table hiveTable = new Table(this.icebergHiveTable, this.icebergHiveDatabase, System.getProperty("user.name"), (int)(currentTimeMillis / 1000L), (int)(currentTimeMillis / 1000L), Integer.MAX_VALUE, new StorageDescriptor(), Collections.emptyList(), new HashMap(), null, null, "EXTERNAL_TABLE");
        hiveTable.getParameters().put("DO_NOT_UPDATE_STATS", "true");
        hiveTable.getParameters().put("EXTERNAL", "TRUE");
        hiveTable.getParameters().put("table_type", "ICEBERG");
        StorageDescriptor sd = hiveTable.getSd();
        sd.setLocation(metadataPath.getParent().getParent().toString());
        sd.setCols(this.table.schema().fields().stream().map(this::convertToFieldSchema).collect(Collectors.toList()));
        sd.setInputFormat("org.apache.hadoop.mapred.FileInputFormat");
        sd.setOutputFormat("org.apache.hadoop.mapred.FileOutputFormat");
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.setSerializationLib("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
        hiveTable.getSd().setSerdeInfo(serDeInfo);
        this.clients.execute(client -> client.createTable(hiveTable));
        return hiveTable;
    }

    private FieldSchema convertToFieldSchema(DataField dataField) {
        return new FieldSchema(dataField.name(), HiveTypeUtils.toTypeInfo(dataField.type()).getTypeName(), dataField.description());
    }
}

