/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.postpone;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.deletionvectors.DeletionVectorsMaintainer;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.KeyValueFileWriterFactory;
import org.apache.paimon.operation.AbstractFileStoreWrite;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.options.Options;
import org.apache.paimon.postpone.PostponeBucketWriter;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.CommitIncrement;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;

public class PostponeBucketFileStoreWrite
extends AbstractFileStoreWrite<KeyValue> {
    private final CoreOptions options;
    private final KeyValueFileWriterFactory.Builder writerFactoryBuilder;

    public PostponeBucketFileStoreWrite(FileIO fileIO, TableSchema schema, String commitUser, RowType partitionType, RowType keyType, RowType valueType, BiFunction<CoreOptions, String, FileStorePathFactory> formatPathFactory, SnapshotManager snapshotManager, FileStoreScan scan, CoreOptions options, String tableName) {
        super(snapshotManager, scan, null, null, tableName, options, partitionType);
        Options newOptions = new Options(options.toMap());
        newOptions.set(CoreOptions.FILE_FORMAT, "avro");
        newOptions.set(CoreOptions.METADATA_STATS_MODE, "none");
        newOptions.set(CoreOptions.DATA_FILE_PREFIX, String.format("%s-u-%s-s-%d-w-", options.dataFilePrefix(), commitUser, ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)));
        this.options = new CoreOptions(newOptions);
        this.writerFactoryBuilder = KeyValueFileWriterFactory.builder(fileIO, schema.id(), keyType, valueType, this.options.fileFormat(), FileStorePathFactory.createFormatPathFactories(this.options, formatPathFactory), this.options.targetFileSize(true));
        this.withIgnorePreviousFiles(true);
    }

    protected PostponeBucketWriter createWriter(BinaryRow partition, int bucket, List<DataFileMeta> restoreFiles, long restoredMaxSeqNumber, @Nullable CommitIncrement restoreIncrement, ExecutorService compactExecutor, @Nullable DeletionVectorsMaintainer deletionVectorsMaintainer) {
        Preconditions.checkArgument(bucket == -2);
        KeyValueFileWriterFactory writerFactory = this.writerFactoryBuilder.build(partition, bucket, this.options);
        return new PostponeBucketWriter(writerFactory);
    }

    @Override
    protected Function<AbstractFileStoreWrite.WriterContainer<KeyValue>, Boolean> createWriterCleanChecker() {
        return PostponeBucketFileStoreWrite.createNoConflictAwareWriterCleanChecker();
    }
}

