/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.spark.SparkCatalog;
import org.apache.paimon.spark.SparkCatalogOptions;
import org.apache.paimon.spark.catalog.SparkBaseCatalog;
import org.apache.paimon.spark.util.SQLConfUtils;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogExtension;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.PaimonCatalogUtils;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.V2SessionCatalog;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.internal.StaticSQLConf;
import org.apache.spark.sql.paimon.shims.SparkShimLoader;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkGenericCatalog
extends SparkBaseCatalog
implements CatalogExtension {
    private static final Logger LOG = LoggerFactory.getLogger(SparkGenericCatalog.class);
    private SparkCatalog sparkCatalog = null;
    private boolean underlyingSessionCatalogEnabled = false;
    private CatalogPlugin sessionCatalog = null;

    @Override
    public Catalog paimonCatalog() {
        return this.sparkCatalog.paimonCatalog();
    }

    public String[] defaultNamespace() {
        return this.asNamespaceCatalog().defaultNamespace();
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().listNamespaces();
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().listNamespaces(namespace);
    }

    public boolean namespaceExists(String[] namespace) {
        return this.asNamespaceCatalog().namespaceExists(namespace);
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        return this.asNamespaceCatalog().loadNamespaceMetadata(namespace);
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        this.asNamespaceCatalog().createNamespace(namespace, metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
        this.asNamespaceCatalog().alterNamespace(namespace, changes);
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        if (namespace.length == 1 && this.namespaceExists(namespace) && cascade) {
            for (Identifier table : this.listTables(namespace)) {
                try {
                    this.dropTable(table);
                }
                catch (Exception e) {
                    LOG.warn("Failed to drop {}, fallback to use sessionCatalog to drop, for {}", (Object)table, (Object)e.getMessage());
                }
            }
        }
        return this.asNamespaceCatalog().dropNamespace(namespace, cascade);
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        return this.asTableCatalog().listTables(namespace);
    }

    public Table loadTable(Identifier ident) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.asTableCatalog().loadTable(ident), e);
        }
    }

    public Table loadTable(Identifier ident, String version) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident, version);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.asTableCatalog().loadTable(ident, version), e);
        }
    }

    public Table loadTable(Identifier ident, long timestamp) throws NoSuchTableException {
        try {
            return this.sparkCatalog.loadTable(ident, timestamp);
        }
        catch (NoSuchTableException e) {
            return this.throwsOldIfExceptionHappens(() -> this.asTableCatalog().loadTable(ident, timestamp), e);
        }
    }

    public void invalidateTable(Identifier ident) {
        this.sparkCatalog.invalidateTable(ident);
        this.asTableCatalog().invalidateTable(ident);
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        String provider = properties.get("provider");
        if (this.usePaimon(provider)) {
            return this.sparkCatalog.createTable(ident, schema, partitions, properties);
        }
        return SparkShimLoader.getSparkShim().createTable(this.asTableCatalog(), ident, schema, partitions, properties);
    }

    public Table alterTable(Identifier ident, TableChange ... changes) throws NoSuchTableException {
        if (this.sparkCatalog.tableExists(ident)) {
            return this.sparkCatalog.alterTable(ident, changes);
        }
        return this.asTableCatalog().alterTable(ident, changes);
    }

    public boolean dropTable(Identifier ident) {
        return this.sparkCatalog.dropTable(ident) || this.asTableCatalog().dropTable(ident);
    }

    public boolean purgeTable(Identifier ident) {
        return this.sparkCatalog.purgeTable(ident) || this.asTableCatalog().purgeTable(ident);
    }

    public void renameTable(Identifier from, Identifier to) throws NoSuchTableException, TableAlreadyExistsException {
        if (this.sparkCatalog.tableExists(from)) {
            this.sparkCatalog.renameTable(from, to);
        } else {
            this.asTableCatalog().renameTable(from, to);
        }
    }

    public final void initialize(String name, CaseInsensitiveStringMap options) {
        String envHmsUri;
        String uri;
        SparkSession sparkSession = SparkSession.active();
        SessionState sessionState = sparkSession.sessionState();
        Configuration hadoopConf = sessionState.newHadoopConf();
        if (options.containsKey((Object)CatalogOptions.METASTORE.key()) && options.get((Object)CatalogOptions.METASTORE.key()).equalsIgnoreCase("hive") && (uri = options.get((Object)CatalogOptions.URI.key())) != null && (envHmsUri = hadoopConf.get("hive.metastore.uris", null)) != null) {
            Preconditions.checkArgument(uri.equals(envHmsUri), "Inconsistent Hive metastore URIs: %s (Spark session) != %s (spark_catalog)", envHmsUri, uri);
        }
        this.catalogName = name;
        this.sparkCatalog = new SparkCatalog();
        CaseInsensitiveStringMap newOptions = this.autoFillConfigurations(options, sessionState.conf(), hadoopConf);
        this.sparkCatalog.initialize(name, newOptions);
        if (options.getBoolean(SparkCatalogOptions.CREATE_UNDERLYING_SESSION_CATALOG.key(), SparkCatalogOptions.CREATE_UNDERLYING_SESSION_CATALOG.defaultValue().booleanValue())) {
            this.underlyingSessionCatalogEnabled = true;
            SparkConf sparkConf = new SparkConf();
            for (Map.Entry entry : options.entrySet()) {
                sparkConf.set("spark.hadoop." + (String)entry.getKey(), (String)entry.getValue());
                hadoopConf.set((String)entry.getKey(), (String)entry.getValue());
            }
            ExternalCatalog externalCatalog = PaimonCatalogUtils.buildExternalCatalog(sparkConf, hadoopConf);
            this.sessionCatalog = new V2SessionCatalog(new SessionCatalog(externalCatalog));
        }
    }

    private CaseInsensitiveStringMap autoFillConfigurations(CaseInsensitiveStringMap options, SQLConf sqlConf, Configuration hadoopConf) {
        HashMap<String, String> newOptions = new HashMap<String, String>(options.asCaseSensitiveMap());
        this.fillAliyunConfigurations(newOptions, hadoopConf);
        this.fillCommonConfigurations(newOptions, sqlConf);
        return new CaseInsensitiveStringMap(newOptions);
    }

    private void fillAliyunConfigurations(Map<String, String> options, Configuration hadoopConf) {
        String aliyunEMRHiveMetastoreType;
        if (!options.containsKey(CatalogOptions.METASTORE.key()) && "dlf".equalsIgnoreCase(aliyunEMRHiveMetastoreType = hadoopConf.get("hive.metastore.type", null))) {
            options.put(CatalogOptions.METASTORE.key(), "dlf");
        }
    }

    private void fillCommonConfigurations(Map<String, String> options, SQLConf sqlConf) {
        String metastore;
        if (!options.containsKey(CatalogOptions.WAREHOUSE.key())) {
            String warehouse = sqlConf.warehousePath();
            options.put(CatalogOptions.WAREHOUSE.key(), warehouse);
        }
        if (!options.containsKey(CatalogOptions.METASTORE.key()) && "hive".equals(metastore = (String)sqlConf.getConf(StaticSQLConf.CATALOG_IMPLEMENTATION()))) {
            options.put(CatalogOptions.METASTORE.key(), metastore);
        }
        options.put(CatalogOptions.FORMAT_TABLE_ENABLED.key(), "false");
        String sessionCatalogDefaultDatabase = SQLConfUtils.defaultDatabase(sqlConf);
        if (options.containsKey(SparkCatalogOptions.DEFAULT_DATABASE.key())) {
            String userDefineDefaultDatabase = options.get(SparkCatalogOptions.DEFAULT_DATABASE.key());
            if (!userDefineDefaultDatabase.equals(sessionCatalogDefaultDatabase)) {
                LOG.warn(String.format("The current spark version does not support configuring default database, switch database to %s", sessionCatalogDefaultDatabase));
                options.put(SparkCatalogOptions.DEFAULT_DATABASE.key(), sessionCatalogDefaultDatabase);
            }
        } else {
            options.put(SparkCatalogOptions.DEFAULT_DATABASE.key(), sessionCatalogDefaultDatabase);
        }
    }

    public void setDelegateCatalog(CatalogPlugin delegate) {
        if (!this.underlyingSessionCatalogEnabled) {
            this.sessionCatalog = delegate;
        }
    }

    private CatalogPlugin getDelegateCatalog() {
        Preconditions.checkNotNull(this.sessionCatalog, "Delegated SessionCatalog is missing, '%s' can only be used with 'spark_catalog'.", SparkGenericCatalog.class.getName());
        return this.sessionCatalog;
    }

    private TableCatalog asTableCatalog() {
        return (TableCatalog)this.getDelegateCatalog();
    }

    private SupportsNamespaces asNamespaceCatalog() {
        return (SupportsNamespaces)this.getDelegateCatalog();
    }

    private FunctionCatalog asFunctionCatalog() {
        return (FunctionCatalog)this.getDelegateCatalog();
    }

    public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        try {
            return this.sparkCatalog.listFunctions(namespace);
        }
        catch (NoSuchNamespaceException e) {
            return this.asFunctionCatalog().listFunctions(namespace);
        }
    }

    public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        try {
            return this.sparkCatalog.loadFunction(ident);
        }
        catch (NoSuchFunctionException e) {
            return this.asFunctionCatalog().loadFunction(ident);
        }
    }

    private Table throwsOldIfExceptionHappens(Callable<Table> call, NoSuchTableException e) throws NoSuchTableException {
        try {
            return call.call();
        }
        catch (Exception exception) {
            throw e;
        }
    }
}

