/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalog;

import org.apache.paimon.spark.catalog.functions.PaimonFunctions;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.connector.catalog.FunctionCatalog;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;

public interface SupportFunction
extends FunctionCatalog,
SupportsNamespaces {
    default public boolean isFunctionNamespace(String[] namespace) {
        return namespace.length == 0 || namespace.length == 1 && this.namespaceExists(namespace);
    }

    default public Identifier[] listFunctions(String[] namespace) throws NoSuchNamespaceException {
        if (this.isFunctionNamespace(namespace)) {
            return (Identifier[])PaimonFunctions.names().stream().map(name -> Identifier.of((String[])namespace, (String)name)).toArray(Identifier[]::new);
        }
        throw new NoSuchNamespaceException(namespace);
    }

    default public UnboundFunction loadFunction(Identifier ident) throws NoSuchFunctionException {
        UnboundFunction func;
        if (this.isFunctionNamespace(ident.namespace()) && (func = PaimonFunctions.load(ident.name())) != null) {
            return func;
        }
        throw new NoSuchFunctionException(ident);
    }
}

