/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.catalog;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.spark.SparkTypeUtils;
import org.apache.paimon.spark.catalog.WithPaimonCatalog;
import org.apache.paimon.spark.utils.CatalogUtils;
import org.apache.paimon.view.View;
import org.apache.paimon.view.ViewImpl;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.types.StructType;

public interface SupportView
extends WithPaimonCatalog {
    public static final String DIALECT = "spark";

    default public List<String> listViews(String[] namespace) throws NoSuchNamespaceException {
        try {
            CatalogUtils.checkNamespace(namespace);
            return this.paimonCatalog().listViews(namespace[0]);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(namespace);
        }
    }

    default public View loadView(org.apache.spark.sql.connector.catalog.Identifier ident) throws Catalog.ViewNotExistException {
        return this.paimonCatalog().getView(CatalogUtils.toIdentifier(ident));
    }

    default public void createView(org.apache.spark.sql.connector.catalog.Identifier ident, StructType schema, String queryText, String comment, Map<String, String> properties, Boolean ignoreIfExists) throws NoSuchNamespaceException {
        Identifier paimonIdent = CatalogUtils.toIdentifier(ident);
        try {
            this.paimonCatalog().createView(paimonIdent, new ViewImpl(paimonIdent, SparkTypeUtils.toPaimonRowType(schema).getFields(), queryText, Collections.singletonMap(DIALECT, queryText), comment, properties), ignoreIfExists);
        }
        catch (Catalog.ViewAlreadyExistException e) {
            throw new RuntimeException("view already exists: " + ident, e);
        }
        catch (Catalog.DatabaseNotExistException e) {
            throw new NoSuchNamespaceException(ident.namespace());
        }
    }

    default public void dropView(org.apache.spark.sql.connector.catalog.Identifier ident, Boolean ignoreIfExists) {
        try {
            this.paimonCatalog().dropView(CatalogUtils.toIdentifier(ident), ignoreIfExists);
        }
        catch (Catalog.ViewNotExistException e) {
            throw new RuntimeException("view not exists: " + ident, e);
        }
    }
}

