/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.util.regex.Pattern;
import org.apache.paimon.consumer.ConsumerManager;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.StringUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class ClearConsumersProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("includingConsumers", DataTypes.StringType), ProcedureParameter.optional("excludingConsumers", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected ClearConsumersProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String includingConsumers = args2.isNullAt(1) ? null : args2.getString(1);
        String excludingConsumers = args2.isNullAt(2) ? null : args2.getString(2);
        Pattern includingPattern = StringUtils.isNullOrWhitespaceOnly(includingConsumers) ? Pattern.compile(".*") : Pattern.compile(includingConsumers);
        Pattern excludingPattern = StringUtils.isNullOrWhitespaceOnly(excludingConsumers) ? null : Pattern.compile(excludingConsumers);
        return this.modifyPaimonTable(tableIdent, table -> {
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            ConsumerManager consumerManager = new ConsumerManager(fileStoreTable.fileIO(), fileStoreTable.location(), fileStoreTable.snapshotManager().branch());
            consumerManager.clearConsumers(includingPattern, excludingPattern);
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ClearConsumersProcedure>(){

            @Override
            public ClearConsumersProcedure doBuild() {
                return new ClearConsumersProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ClearConsumersProcedure";
    }
}

