/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.time.LocalDateTime;
import java.util.List;
import java.util.TimeZone;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.tag.TagTimeExpire;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class ExpireTagsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.optional("older_than", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("expired_tags", DataTypes.StringType, false, Metadata.empty())});

    protected ExpireTagsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String olderThanStr = args2.isNullAt(1) ? null : args2.getString(1);
        return this.modifyPaimonTable(tableIdent, table -> {
            InternalRow[] internalRowArray;
            List<String> expired;
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            TagTimeExpire tagTimeExpire = fileStoreTable.store().newTagCreationManager().getTagTimeExpire();
            if (olderThanStr != null) {
                LocalDateTime olderThanTime = DateTimeUtils.parseTimestampData(olderThanStr, 3, TimeZone.getDefault()).toLocalDateTime();
                tagTimeExpire.withOlderThanTime(olderThanTime);
            }
            if ((expired = tagTimeExpire.expire()).isEmpty()) {
                InternalRow[] internalRowArray2 = new InternalRow[1];
                internalRowArray = internalRowArray2;
                internalRowArray2[0] = this.newInternalRow(UTF8String.fromString((String)"No expired tags."));
            } else {
                internalRowArray = (InternalRow[])expired.stream().map(x -> this.newInternalRow(UTF8String.fromString((String)x))).toArray(InternalRow[]::new);
            }
            return internalRowArray;
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpireTagsProcedure>(){

            @Override
            public ExpireTagsProcedure doBuild() {
                return new ExpireTagsProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ExpireTagsProcedure";
    }
}

