/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class RenameTagProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("tag", DataTypes.StringType), ProcedureParameter.required("target_tag", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("result", DataTypes.BooleanType, true, Metadata.empty())});

    protected RenameTagProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args2) {
        Identifier tableIdent = this.toIdentifier(args2.getString(0), PARAMETERS[0].name());
        String tag = args2.getString(1);
        String targetTag = args2.getString(2);
        return this.modifyPaimonTable(tableIdent, table -> {
            table.renameTag(tag, targetTag);
            InternalRow outputRow = this.newInternalRow(true);
            return new InternalRow[]{outputRow};
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<RenameTagProcedure>(){

            @Override
            public RenameTagProcedure doBuild() {
                return new RenameTagProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "RenameTagProcedure";
    }
}

