/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.spark.procedure.SparkRemoveUnexistingFiles;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.internal.SQLConf;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;

public final class SparkRemoveUnexistingFiles$
implements SQLConfHelper,
Serializable {
    public static SparkRemoveUnexistingFiles$ MODULE$;

    static {
        new SparkRemoveUnexistingFiles$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public String[] execute(Catalog catalog, String databaseName, String tableName, boolean dryRun, Integer parallelismOpt) {
        SparkSession spark = SparkSession$.MODULE$.active();
        int parallelism = parallelismOpt == null ? Math.max(spark.sparkContext().defaultParallelism(), this.conf().numShufflePartitions()) : parallelismOpt;
        Identifier identifier = new Identifier(databaseName, tableName);
        Table table = catalog.getTable(identifier);
        Predef$.MODULE$.assert(table instanceof FileStoreTable, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(82).append("Only FileStoreTable supports remove-unexsiting-files action. The table type is '").append(table.getClass().getName()).append("'.").toString());
        FileStoreTable fileStoreTable = (FileStoreTable)table;
        return (String[])new SparkRemoveUnexistingFiles(fileStoreTable, dryRun, parallelism, spark).org$apache$paimon$spark$procedure$SparkRemoveUnexistingFiles$$buildRDD().collect();
    }

    public SparkRemoveUnexistingFiles apply(FileStoreTable table, boolean dryRun, int parallelism, SparkSession spark) {
        return new SparkRemoveUnexistingFiles(table, dryRun, parallelism, spark);
    }

    public Option<Tuple4<FileStoreTable, Object, Object, SparkSession>> unapply(SparkRemoveUnexistingFiles x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.table(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.dryRun()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelism()), (Object)x$0.spark()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SparkRemoveUnexistingFiles$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
    }
}

