/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.spark.SparkConnectorOptions;
import org.apache.paimon.table.Table;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class OptionUtils$
implements SQLConfHelper {
    public static OptionUtils$ MODULE$;
    private final String PAIMON_OPTION_PREFIX;
    private final String SPARK_CATALOG_PREFIX;

    static {
        new OptionUtils$();
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    private String PAIMON_OPTION_PREFIX() {
        return this.PAIMON_OPTION_PREFIX;
    }

    private String SPARK_CATALOG_PREFIX() {
        return this.SPARK_CATALOG_PREFIX;
    }

    public boolean paimonExtensionEnabled() {
        return ((SeqLike)this.conf().getConf(StaticSQLConf$.MODULE$.SPARK_SESSION_EXTENSIONS()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$)).contains((Object)"org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions");
    }

    public String getOptionString(ConfigOption<?> option) {
        return this.conf().getConfString(new StringBuilder(0).append(this.PAIMON_OPTION_PREFIX()).append(option.key()).toString(), option.defaultValue().toString());
    }

    public void checkRequiredConfigurations() {
        if (new StringOps(Predef$.MODULE$.augmentString(this.getOptionString(SparkConnectorOptions.REQUIRED_SPARK_CONFS_CHECK_ENABLED))).toBoolean() && !this.paimonExtensionEnabled()) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("\n            |When using Paimon, it is necessary to configure `spark.sql.extensions` and ensure that it includes `org.apache.paimon.spark.extensions.PaimonSparkSessionExtensions`.\n            |You can disable this check by configuring `spark.paimon.requiredSparkConfsCheck.enabled` to `false`, but it is strongly discouraged to do so.\n            |")).stripMargin());
        }
    }

    public Option<String> extractCatalogName() {
        Option option;
        Object object = new Object();
        try {
            String sparkCatalogTemplate = String.format("%s([^.]*)$", this.SPARK_CATALOG_PREFIX());
            Pattern sparkCatalogPattern = Pattern.compile(sparkCatalogTemplate);
            this.conf().getAllConfs().filterKeys((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(OptionUtils$.MODULE$.SPARK_CATALOG_PREFIX()))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                OptionUtils$.$anonfun$extractCatalogName$2(sparkCatalogPattern, object, x0$1);
                return BoxedUnit.UNIT;
            });
            option = Option$.MODULE$.empty();
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public java.util.Map<String, String> mergeSQLConfWithIdentifier(java.util.Map<String, String> extraOptions, String catalogName, Identifier ident) {
        String tableOptionsTemplate = String.format("(%s)(%s|\\*)\\.(%s|\\*)\\.(%s|\\*)\\.(.+)", this.PAIMON_OPTION_PREFIX(), catalogName, ident.getDatabaseName(), ident.getObjectName());
        Pattern tableOptionsPattern = Pattern.compile(tableOptionsTemplate);
        java.util.Map<String, String> mergedOptions = OptionsUtils.convertToDynamicTableProperties((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.conf().getAllConfs()).asJava(), this.PAIMON_OPTION_PREFIX(), tableOptionsPattern, 5);
        mergedOptions.putAll(extraOptions);
        return mergedOptions;
    }

    public <T extends Table> T copyWithSQLConf(T table, String catalogName, Identifier ident, java.util.Map<String, String> extraOptions) {
        java.util.Map<String, String> mergedOptions = this.mergeSQLConfWithIdentifier(extraOptions, catalogName, ident);
        return (T)(mergedOptions.isEmpty() ? table : table.copy(mergedOptions));
    }

    public static final /* synthetic */ void $anonfun$extractCatalogName$2(Pattern sparkCatalogPattern$1, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Matcher matcher = sparkCatalogPattern$1.matcher(key);
            if (matcher.find()) {
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)Option$.MODULE$.apply((Object)matcher.group(1)));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private OptionUtils$() {
        MODULE$ = this;
        SQLConfHelper.$init$((SQLConfHelper)this);
        this.PAIMON_OPTION_PREFIX = "spark.paimon.";
        this.SPARK_CATALOG_PREFIX = "spark.sql.catalog.";
    }
}

