/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.casting.CastExecutor;
import org.apache.paimon.casting.CastExecutors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.LazyGenericRow;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.predicate.Equal;
import org.apache.paimon.predicate.LeafPredicate;
import org.apache.paimon.predicate.LeafPredicateExtractor;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.stats.SimpleStatsEvolution;
import org.apache.paimon.stats.SimpleStatsEvolutions;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.DataTableScan;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.SingletonSplit;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.apache.paimon.utils.SerializationUtils;

public class FilesTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String FILES = "files";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "partition", SerializationUtils.newStringType(true)), new DataField(1, "bucket", new IntType(false)), new DataField(2, "file_path", SerializationUtils.newStringType(false)), new DataField(3, "file_format", SerializationUtils.newStringType(false)), new DataField(4, "schema_id", new BigIntType(false)), new DataField(5, "level", new IntType(false)), new DataField(6, "record_count", new BigIntType(false)), new DataField(7, "file_size_in_bytes", new BigIntType(false)), new DataField(8, "min_key", SerializationUtils.newStringType(true)), new DataField(9, "max_key", SerializationUtils.newStringType(true)), new DataField(10, "null_value_counts", SerializationUtils.newStringType(false)), new DataField(11, "min_value_stats", SerializationUtils.newStringType(false)), new DataField(12, "max_value_stats", SerializationUtils.newStringType(false)), new DataField(13, "min_sequence_number", new BigIntType(true)), new DataField(14, "max_sequence_number", new BigIntType(true)), new DataField(15, "creation_time", DataTypes.TIMESTAMP_MILLIS()), new DataField(16, "file_source", DataTypes.STRING())));
    private final FileStoreTable storeTable;

    public FilesTable(FileStoreTable storeTable) {
        this.storeTable = storeTable;
    }

    @Override
    public String name() {
        return this.storeTable.name() + "$" + FILES;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("file_path");
    }

    @Override
    public FileIO fileIO() {
        return this.storeTable.fileIO();
    }

    @Override
    public InnerTableScan newScan() {
        return new FilesScan(this.storeTable);
    }

    @Override
    public InnerTableRead newRead() {
        return new FilesRead(this.storeTable.schemaManager(), this.storeTable);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new FilesTable((FileStoreTable)this.storeTable.copy((Map)dynamicOptions));
    }

    private static class StatsLazyGetter {
        private final DataFileMeta file;
        private final SimpleStatsEvolutions simpleStatsEvolutions;
        private Map<String, Long> lazyNullValueCounts;
        private Map<String, Object> lazyLowerValueBounds;
        private Map<String, Object> lazyUpperValueBounds;

        private StatsLazyGetter(DataFileMeta file, SimpleStatsEvolutions simpleStatsEvolutions) {
            this.file = file;
            this.simpleStatsEvolutions = simpleStatsEvolutions;
        }

        private void initialize() {
            SimpleStatsEvolution evolution = this.simpleStatsEvolutions.getOrCreate(this.file.schemaId());
            SimpleStatsEvolution.Result result = evolution.evolution(this.file.valueStats(), this.file.rowCount(), this.file.valueStatsCols());
            InternalRow min = result.minValues();
            InternalRow max = result.maxValues();
            InternalArray nullCounts = result.nullCounts();
            this.lazyNullValueCounts = new TreeMap<String, Long>();
            this.lazyLowerValueBounds = new TreeMap<String, Object>();
            this.lazyUpperValueBounds = new TreeMap<String, Object>();
            for (int i = 0; i < min.getFieldCount(); ++i) {
                DataField field = this.simpleStatsEvolutions.tableDataFields().get(i);
                String name = field.name();
                DataType type = field.type();
                this.lazyNullValueCounts.put(name, nullCounts.isNullAt(i) ? null : Long.valueOf(nullCounts.getLong(i)));
                this.lazyLowerValueBounds.put(name, InternalRowUtils.get(min, i, type));
                this.lazyUpperValueBounds.put(name, InternalRowUtils.get(max, i, type));
            }
        }

        private Map<String, Long> nullValueCounts() {
            if (this.lazyNullValueCounts == null) {
                this.initialize();
            }
            return this.lazyNullValueCounts;
        }

        private Map<String, Object> lowerValueBounds() {
            if (this.lazyLowerValueBounds == null) {
                this.initialize();
            }
            return this.lazyLowerValueBounds;
        }

        private Map<String, Object> upperValueBounds() {
            if (this.lazyUpperValueBounds == null) {
                this.initialize();
            }
            return this.lazyUpperValueBounds;
        }
    }

    private static class FilesRead
    implements InnerTableRead {
        private final SchemaManager schemaManager;
        private final FileStoreTable storeTable;
        private RowType readType;

        private FilesRead(SchemaManager schemaManager, FileStoreTable fileStoreTable) {
            this.schemaManager = schemaManager;
            this.storeTable = fileStoreTable;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withReadType(RowType readType) {
            this.readType = readType;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) {
            if (!(split instanceof FilesSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            FilesSplit filesSplit = (FilesSplit)split;
            List<Split> splits = filesSplit.splits(this.storeTable);
            if (splits.isEmpty()) {
                return new IteratorRecordReader<InternalRow>(Collections.emptyIterator());
            }
            ArrayList iteratorList = new ArrayList();
            SimpleStatsEvolutions simpleStatsEvolutions = new SimpleStatsEvolutions(sid -> this.schemaManager.schema((long)sid).fields(), this.storeTable.schema().id());
            CastExecutor<?, ?> partitionCastExecutor = CastExecutors.resolveToString(this.storeTable.schema().logicalPartitionType());
            Function<Long, RowDataToObjectArrayConverter> keyConverters = new Function<Long, RowDataToObjectArrayConverter>(){
                final Map<Long, RowDataToObjectArrayConverter> keyConverterMap = new HashMap<Long, RowDataToObjectArrayConverter>();

                @Override
                public RowDataToObjectArrayConverter apply(Long schemaId) {
                    return this.keyConverterMap.computeIfAbsent(schemaId, k -> {
                        TableSchema dataSchema = schemaManager.schema(schemaId);
                        RowType keysType = dataSchema.logicalTrimmedPrimaryKeysType();
                        return keysType.getFieldCount() > 0 ? new RowDataToObjectArrayConverter(dataSchema.logicalTrimmedPrimaryKeysType()) : new RowDataToObjectArrayConverter(dataSchema.logicalRowType());
                    });
                }
            };
            for (Split dataSplit : splits) {
                iteratorList.add(Iterators.transform(((DataSplit)dataSplit).dataFiles().iterator(), file -> this.toRow((DataSplit)dataSplit, (CastExecutor<InternalRow, BinaryString>)partitionCastExecutor, keyConverters, (DataFileMeta)file, simpleStatsEvolutions)));
            }
            Iterator rows = Iterators.concat(iteratorList.iterator());
            if (this.readType != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.readType, TABLE_TYPE).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private LazyGenericRow toRow(DataSplit dataSplit, CastExecutor<InternalRow, BinaryString> partitionCastExecutor, Function<Long, RowDataToObjectArrayConverter> keyConverters, DataFileMeta file, SimpleStatsEvolutions simpleStatsEvolutions) {
            StatsLazyGetter statsGetter = new StatsLazyGetter(file, simpleStatsEvolutions);
            Supplier[] supplierArray = new Supplier[17];
            supplierArray[0] = () -> dataSplit.partition() == null ? null : partitionCastExecutor.cast(dataSplit.partition());
            supplierArray[1] = dataSplit::bucket;
            supplierArray[2] = () -> BinaryString.fromString(file.externalPath().orElse(dataSplit.bucketPath() + "/" + file.fileName()));
            supplierArray[3] = () -> BinaryString.fromString(DataFilePathFactory.formatIdentifier(file.fileName()));
            supplierArray[4] = file::schemaId;
            supplierArray[5] = file::level;
            supplierArray[6] = file::rowCount;
            supplierArray[7] = file::fileSize;
            supplierArray[8] = () -> file.minKey().getFieldCount() <= 0 ? null : BinaryString.fromString(Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(file.schemaId())).convert(file.minKey())));
            supplierArray[9] = () -> file.maxKey().getFieldCount() <= 0 ? null : BinaryString.fromString(Arrays.toString(((RowDataToObjectArrayConverter)keyConverters.apply(file.schemaId())).convert(file.maxKey())));
            supplierArray[10] = () -> BinaryString.fromString(statsGetter.nullValueCounts().toString());
            supplierArray[11] = () -> BinaryString.fromString(statsGetter.lowerValueBounds().toString());
            supplierArray[12] = () -> BinaryString.fromString(statsGetter.upperValueBounds().toString());
            supplierArray[13] = file::minSequenceNumber;
            supplierArray[14] = file::maxSequenceNumber;
            supplierArray[15] = file::creationTime;
            supplierArray[16] = () -> BinaryString.fromString(file.fileSource().map(Enum::toString).orElse(null));
            Supplier[] fields = supplierArray;
            return new LazyGenericRow(fields);
        }
    }

    private static class FilesSplit
    extends SingletonSplit {
        @Nullable
        private final BinaryRow partition;
        @Nullable
        private final LeafPredicate bucketPredicate;
        @Nullable
        private final LeafPredicate levelPredicate;

        private FilesSplit(@Nullable BinaryRow partition, @Nullable LeafPredicate bucketPredicate, @Nullable LeafPredicate levelPredicate) {
            this.partition = partition;
            this.bucketPredicate = bucketPredicate;
            this.levelPredicate = levelPredicate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilesSplit that = (FilesSplit)o;
            return Objects.equals(this.partition, that.partition) && Objects.equals(this.bucketPredicate, that.bucketPredicate) && Objects.equals(this.levelPredicate, that.levelPredicate);
        }

        public int hashCode() {
            return Objects.hash(this.partition, this.bucketPredicate, this.levelPredicate);
        }

        public List<Split> splits(FileStoreTable storeTable) {
            return this.tablePlan(storeTable).splits();
        }

        private TableScan.Plan tablePlan(FileStoreTable storeTable) {
            DataTableScan scan = storeTable.newScan();
            if (this.partition != null) {
                scan.withPartitionFilter(Collections.singletonList(this.partition));
            }
            if (this.bucketPredicate != null) {
                scan.withBucketFilter(bucket -> this.bucketPredicate.test(GenericRow.of(null, bucket)));
            }
            if (this.levelPredicate != null) {
                scan.withLevelFilter(level -> this.levelPredicate.test(GenericRow.of(null, null, null, null, null, level)));
            }
            return scan.plan();
        }
    }

    private static class FilesScan
    extends ReadOnceTableScan {
        @Nullable
        private LeafPredicate partitionPredicate;
        @Nullable
        private LeafPredicate bucketPredicate;
        @Nullable
        private LeafPredicate levelPredicate;
        private final FileStoreTable fileStoreTable;

        public FilesScan(FileStoreTable fileStoreTable) {
            this.fileStoreTable = fileStoreTable;
        }

        @Override
        public InnerTableScan withFilter(Predicate pushdown) {
            if (pushdown == null) {
                return this;
            }
            Map<String, LeafPredicate> leafPredicates = pushdown.visit(LeafPredicateExtractor.INSTANCE);
            this.partitionPredicate = leafPredicates.get("partition");
            this.bucketPredicate = leafPredicates.get("bucket");
            this.levelPredicate = leafPredicates.get("level");
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            SnapshotReader snapshotReader = this.fileStoreTable.newSnapshotReader();
            if (this.partitionPredicate != null && this.partitionPredicate.function() instanceof Equal) {
                String partitionStr = this.partitionPredicate.literals().get(0).toString();
                if (partitionStr.startsWith("{")) {
                    partitionStr = partitionStr.substring(1);
                }
                if (partitionStr.endsWith("}")) {
                    partitionStr = partitionStr.substring(0, partitionStr.length() - 1);
                }
                String[] partFields = partitionStr.split(", ");
                LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
                List<String> partitionKeys = this.fileStoreTable.partitionKeys();
                if (partitionKeys.size() != partFields.length) {
                    return Collections::emptyList;
                }
                for (int i = 0; i < partitionKeys.size(); ++i) {
                    partSpec.put(partitionKeys.get(i), partFields[i]);
                }
                snapshotReader.withPartitionFilter(partSpec);
            }
            return () -> snapshotReader.partitions().stream().map(p -> new FilesSplit((BinaryRow)p, this.bucketPredicate, this.levelPredicate)).collect(Collectors.toList());
        }
    }
}

