/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.paimon.spark.PaimonSparkScalarFunction;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class LambdaScalarFunction
implements UnboundFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private DataType outputType;
    private String javaType;
    private String functionName;
    private String lambdaExpression;

    public LambdaScalarFunction(String functionName, DataType outputType, String javaType, String lambdaExpression) {
        try {
            this.outputType = outputType;
            this.javaType = javaType;
            this.functionName = functionName;
            this.lambdaExpression = lambdaExpression;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compile lambda expression", e);
        }
    }

    public BoundFunction bind(StructType inputType) {
        try {
            ArrayList<DataType> inputTypes = new ArrayList<DataType>();
            for (StructField field : inputType.fields()) {
                inputTypes.add(field.dataType());
            }
            return new PaimonSparkScalarFunction(this.functionName, inputTypes, this.outputType, this.javaType, this.lambdaExpression);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String description() {
        return "";
    }

    public String name() {
        return this.functionName;
    }
}

