/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.utils.Preconditions;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.connector.catalog.ColumnDefaultValue;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.MapType;

public class CatalogUtils {
    public static void checkNamespace(String[] namespace) {
        Preconditions.checkArgument(namespace.length == 1, "Paimon only support single namespace, but got %s", Arrays.toString(namespace));
    }

    public static org.apache.paimon.catalog.Identifier toIdentifier(Identifier ident) {
        CatalogUtils.checkNamespace(ident.namespace());
        return new org.apache.paimon.catalog.Identifier(ident.namespace()[0], ident.name());
    }

    public static Identifier removeCatalogName(Identifier ident, String catalogName) {
        String[] namespace = ident.namespace();
        if (namespace.length > 1) {
            Preconditions.checkArgument(namespace[0].equals(catalogName), "Only supports operations within the same catalog, target catalog name: %s, current catalog name: %s", namespace[0], catalogName);
            return Identifier.of((String[])Arrays.copyOfRange(namespace, 1, namespace.length), (String)ident.name());
        }
        return ident;
    }

    public static org.apache.spark.sql.types.DataType paimonType2SparkType(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return DataTypes.StringType;
            }
            case BOOLEAN: {
                return DataTypes.BooleanType;
            }
            case BINARY: 
            case VARBINARY: {
                return DataTypes.BinaryType;
            }
            case TINYINT: {
                return DataTypes.ByteType;
            }
            case SMALLINT: {
                return DataTypes.ShortType;
            }
            case INTEGER: {
                return DataTypes.IntegerType;
            }
            case BIGINT: {
                return DataTypes.LongType;
            }
            case FLOAT: {
                return DataTypes.FloatType;
            }
            case DOUBLE: {
                return DataTypes.DoubleType;
            }
            case DECIMAL: {
                org.apache.paimon.types.DecimalType decimalType = (org.apache.paimon.types.DecimalType)type;
                return DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale());
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return DataTypes.TimestampType;
            }
            case ARRAY: {
                return DataTypes.createArrayType((org.apache.spark.sql.types.DataType)CatalogUtils.paimonType2SparkType(((ArrayType)type).getElementType()));
            }
            case MAP: 
            case MULTISET: {
                DataType valueType;
                DataType keyType;
                if (type instanceof org.apache.paimon.types.MapType) {
                    keyType = ((org.apache.paimon.types.MapType)type).getKeyType();
                    valueType = ((org.apache.paimon.types.MapType)type).getValueType();
                } else if (type instanceof MultisetType) {
                    keyType = ((MultisetType)type).getElementType();
                    valueType = new IntType();
                } else {
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
                return DataTypes.createMapType((org.apache.spark.sql.types.DataType)CatalogUtils.paimonType2SparkType(keyType), (org.apache.spark.sql.types.DataType)CatalogUtils.paimonType2SparkType(valueType));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static String paimonType2JavaType(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return "java.lang.String";
            }
            case BOOLEAN: {
                return "java.lang.Boolean";
            }
            case BINARY: 
            case VARBINARY: {
                return "byte[]";
            }
            case TINYINT: {
                return "java.lang.Byte";
            }
            case SMALLINT: {
                return "java.lang.Short";
            }
            case INTEGER: {
                return "java.lang.Integer";
            }
            case BIGINT: {
                return "java.lang.Long";
            }
            case FLOAT: {
                return "java.lang.Float";
            }
            case DOUBLE: {
                return "java.lang.Double";
            }
            case DECIMAL: {
                return "java.math.BigDecimal";
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return "java.time.Instant";
            }
            case ARRAY: {
                return CatalogUtils.paimonType2JavaType(((ArrayType)type).getElementType()) + "[]";
            }
            case MAP: 
            case MULTISET: {
                DataType valueType;
                DataType keyType;
                if (type instanceof org.apache.paimon.types.MapType) {
                    keyType = ((org.apache.paimon.types.MapType)type).getKeyType();
                    valueType = ((org.apache.paimon.types.MapType)type).getValueType();
                } else if (type instanceof MultisetType) {
                    keyType = ((MultisetType)type).getElementType();
                    valueType = new IntType();
                } else {
                    throw new UnsupportedOperationException("Unsupported type: " + type);
                }
                return String.format("java.util.Map<%s,%s>", CatalogUtils.paimonType2JavaType(keyType), CatalogUtils.paimonType2JavaType(valueType));
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static Object convertSparkJavaToPaimonJava(org.apache.spark.sql.types.DataType sparkType, Object value) {
        if (value == null) {
            return null;
        }
        if (sparkType == DataTypes.StringType) {
            return value.toString();
        }
        if (sparkType == DataTypes.BooleanType) {
            return (Boolean)value;
        }
        if (sparkType == DataTypes.BinaryType) {
            return (byte[])value;
        }
        if (sparkType == DataTypes.ByteType) {
            return (byte)((Byte)value);
        }
        if (sparkType == DataTypes.ShortType) {
            return (short)((Short)value);
        }
        if (sparkType == DataTypes.IntegerType) {
            return (Integer)value;
        }
        if (sparkType == DataTypes.LongType) {
            return (Long)value;
        }
        if (sparkType == DataTypes.FloatType) {
            return (Float)value;
        }
        if (sparkType == DataTypes.DoubleType) {
            return (Double)value;
        }
        if (sparkType instanceof DecimalType) {
            return (BigDecimal)value;
        }
        if (sparkType instanceof org.apache.spark.sql.types.ArrayType) {
            org.apache.spark.sql.types.ArrayType arrayType = (org.apache.spark.sql.types.ArrayType)sparkType;
            ArrayList<Object> list = new ArrayList<Object>();
            if (value instanceof GenericArrayData) {
                Object[] array;
                GenericArrayData genericArray = (GenericArrayData)value;
                for (Object elem : array = genericArray.array()) {
                    list.add(CatalogUtils.convertSparkJavaToPaimonJava(arrayType.elementType(), elem));
                }
                return list;
            }
            throw new IllegalArgumentException("Unexpected array type: " + value.getClass());
        }
        if (sparkType instanceof MapType) {
            MapType mapType = (MapType)sparkType;
            if (value instanceof ArrayBasedMapData) {
                ArrayBasedMapData arrayBasedMapData = (ArrayBasedMapData)value;
                Map sparkMap = ArrayBasedMapData.toJavaMap((Object[])arrayBasedMapData.keyArray().array(), (Object[])arrayBasedMapData.valueArray().array());
                HashMap<Object, Object> javaMap = new HashMap<Object, Object>();
                for (Map.Entry entry : sparkMap.entrySet()) {
                    Object key = CatalogUtils.convertSparkJavaToPaimonJava(mapType.keyType(), entry.getKey());
                    Object val = CatalogUtils.convertSparkJavaToPaimonJava(mapType.valueType(), entry.getValue());
                    javaMap.put(key, val);
                }
                return javaMap;
            }
            throw new IllegalArgumentException("Unexpected array type: " + value.getClass());
        }
        throw new IllegalArgumentException("Unsupported Spark data type: " + sparkType);
    }

    public static void checkNoDefaultValue(TableChange.AddColumn addColumn) {
        try {
            ColumnDefaultValue defaultValue = addColumn.defaultValue();
            if (defaultValue != null) {
                throw new IllegalArgumentException(String.format("Cannot add column %s with default value %s.", Arrays.toString(addColumn.fieldNames()), defaultValue));
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
    }

    public static boolean isUpdateColumnDefaultValue(TableChange tableChange) {
        try {
            return tableChange instanceof TableChange.UpdateColumnDefaultValue;
        }
        catch (NoClassDefFoundError ignored) {
            return false;
        }
    }

    public static SchemaChange toUpdateColumnDefaultValue(TableChange tableChange) {
        TableChange.UpdateColumnDefaultValue update = (TableChange.UpdateColumnDefaultValue)tableChange;
        return SchemaChange.updateColumnDefaultValue(update.fieldNames(), update.newDefaultValue());
    }
}

