/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.serializer;

import org.apache.paimon.data.serializer.BinarySerializer;
import org.apache.paimon.data.serializer.BinaryStringSerializer;
import org.apache.paimon.data.serializer.BooleanSerializer;
import org.apache.paimon.data.serializer.ByteSerializer;
import org.apache.paimon.data.serializer.DecimalSerializer;
import org.apache.paimon.data.serializer.DoubleSerializer;
import org.apache.paimon.data.serializer.FloatSerializer;
import org.apache.paimon.data.serializer.IntSerializer;
import org.apache.paimon.data.serializer.InternalArraySerializer;
import org.apache.paimon.data.serializer.InternalMapSerializer;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.LongSerializer;
import org.apache.paimon.data.serializer.Serializer;
import org.apache.paimon.data.serializer.ShortSerializer;
import org.apache.paimon.data.serializer.TimestampSerializer;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MapType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;

public final class InternalSerializers {
    public static <T> Serializer<T> create(DataType type) {
        return InternalSerializers.createInternal(type);
    }

    public static InternalRowSerializer create(RowType type) {
        return (InternalRowSerializer)InternalSerializers.createInternal(type);
    }

    private static Serializer<?> createInternal(DataType type) {
        switch (type.getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                return BinaryStringSerializer.INSTANCE;
            }
            case BOOLEAN: {
                return BooleanSerializer.INSTANCE;
            }
            case BINARY: 
            case VARBINARY: {
                return BinarySerializer.INSTANCE;
            }
            case DECIMAL: {
                return new DecimalSerializer(DataTypeChecks.getPrecision(type), DataTypeChecks.getScale(type));
            }
            case TINYINT: {
                return ByteSerializer.INSTANCE;
            }
            case SMALLINT: {
                return ShortSerializer.INSTANCE;
            }
            case INTEGER: 
            case DATE: 
            case TIME_WITHOUT_TIME_ZONE: {
                return IntSerializer.INSTANCE;
            }
            case BIGINT: {
                return LongSerializer.INSTANCE;
            }
            case FLOAT: {
                return FloatSerializer.INSTANCE;
            }
            case DOUBLE: {
                return DoubleSerializer.INSTANCE;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return new TimestampSerializer(DataTypeChecks.getPrecision(type));
            }
            case ARRAY: {
                return new InternalArraySerializer(((ArrayType)type).getElementType());
            }
            case MULTISET: {
                return new InternalMapSerializer(((MultisetType)type).getElementType(), new IntType(false));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new InternalMapSerializer(mapType.getKeyType(), mapType.getValueType());
            }
            case ROW: {
                return new InternalRowSerializer(DataTypeChecks.getFieldTypes(type).toArray(new DataType[0]));
            }
        }
        throw new UnsupportedOperationException("Unsupported type '" + type + "' to get internal serializer");
    }

    private InternalSerializers() {
    }
}

