/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.MergeSorter;
import org.apache.paimon.mergetree.compact.MergeFunctionWrapper;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.FieldsComparator;

public class DiffReader {
    private static final int BEFORE_LEVEL = Integer.MIN_VALUE;
    private static final int AFTER_LEVEL = Integer.MAX_VALUE;

    public static RecordReader<KeyValue> readDiff(RecordReader<KeyValue> beforeReader, RecordReader<KeyValue> afterReader, Comparator<InternalRow> keyComparator, @Nullable FieldsComparator userDefinedSeqComparator, MergeSorter sorter, boolean keepDelete) throws IOException {
        return sorter.mergeSort(Arrays.asList(() -> DiffReader.wrapLevelToReader(beforeReader, Integer.MIN_VALUE), () -> DiffReader.wrapLevelToReader(afterReader, Integer.MAX_VALUE)), keyComparator, userDefinedSeqComparator, new DiffMerger(keepDelete));
    }

    private static RecordReader<KeyValue> wrapLevelToReader(final RecordReader<KeyValue> reader, final int level) {
        return new RecordReader<KeyValue>(){

            @Override
            @Nullable
            public RecordReader.RecordIterator<KeyValue> readBatch() throws IOException {
                final RecordReader.RecordIterator batch = reader.readBatch();
                if (batch == null) {
                    return null;
                }
                return new RecordReader.RecordIterator<KeyValue>(){

                    @Override
                    @Nullable
                    public KeyValue next() throws IOException {
                        KeyValue kv = (KeyValue)batch.next();
                        if (kv != null) {
                            kv.setLevel(level);
                        }
                        return kv;
                    }

                    @Override
                    public void releaseBatch() {
                        batch.releaseBatch();
                    }
                };
            }

            @Override
            public void close() throws IOException {
                reader.close();
            }
        };
    }

    private static class DiffMerger
    implements MergeFunctionWrapper<KeyValue> {
        private final boolean keepDelete;
        private final List<KeyValue> kvs = new ArrayList<KeyValue>();

        public DiffMerger(boolean keepDelete) {
            this.keepDelete = keepDelete;
        }

        @Override
        public void reset() {
            this.kvs.clear();
        }

        @Override
        public void add(KeyValue kv) {
            this.kvs.add(kv);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @Nullable
        public KeyValue getResult() {
            if (this.kvs.size() == 1) {
                KeyValue kv = this.kvs.get(0);
                if (kv.level() != Integer.MIN_VALUE) return kv;
                if (!this.keepDelete) return null;
                return kv.replaceValueKind(RowKind.DELETE);
            }
            if (this.kvs.size() != 2) throw new IllegalArgumentException("Illegal kv number: " + this.kvs.size());
            KeyValue latest = this.kvs.get(1);
            if (latest.level() != Integer.MAX_VALUE) return null;
            return latest;
        }
    }
}

