/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.parquet.reader;

import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.columnar.BytesColumnVector;
import org.apache.paimon.data.columnar.ColumnVector;
import org.apache.paimon.data.columnar.DecimalColumnVector;
import org.apache.paimon.data.columnar.IntColumnVector;
import org.apache.paimon.data.columnar.LongColumnVector;
import org.apache.paimon.format.parquet.ParquetSchemaConverter;
import org.apache.paimon.shade.org.apache.parquet.Preconditions;

public class ParquetDecimalVector
implements DecimalColumnVector {
    private final ColumnVector vector;

    public ParquetDecimalVector(ColumnVector vector) {
        this.vector = vector;
    }

    @Override
    public Decimal getDecimal(int i, int precision, int scale) {
        if (ParquetSchemaConverter.is32BitDecimal(precision) && this.vector instanceof IntColumnVector) {
            return Decimal.fromUnscaledLong(((IntColumnVector)this.vector).getInt(i), precision, scale);
        }
        if (ParquetSchemaConverter.is64BitDecimal(precision) && this.vector instanceof LongColumnVector) {
            return Decimal.fromUnscaledLong(((LongColumnVector)this.vector).getLong(i), precision, scale);
        }
        Preconditions.checkArgument(this.vector instanceof BytesColumnVector, "Reading decimal type occur unsupported vector type: %s", this.vector.getClass());
        return Decimal.fromUnscaledBytes(((BytesColumnVector)this.vector).getBytes(i).getBytes(), precision, scale);
    }

    public ColumnVector getVector() {
        return this.vector;
    }

    @Override
    public boolean isNullAt(int i) {
        return this.vector.isNullAt(i);
    }
}

