/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.avro;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.GenericArray;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.avro.AvroSchemaVisitor;
import org.apache.paimon.format.avro.FieldReader;
import org.apache.paimon.shade.org.apache.avro.AvroRuntimeException;
import org.apache.paimon.shade.org.apache.avro.Schema;
import org.apache.paimon.shade.org.apache.avro.io.Decoder;
import org.apache.paimon.shade.org.apache.avro.util.Utf8;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.jetbrains.annotations.NotNull;

public class FieldReaderFactory
implements AvroSchemaVisitor<FieldReader> {
    private static final FieldReader STRING_READER = new StringReader();
    private static final FieldReader BYTES_READER = new BytesReader();
    private static final FieldReader BOOLEAN_READER = new BooleanReader();
    private static final FieldReader TINYINT_READER = new TinyIntReader();
    private static final FieldReader SMALLINT_READER = new SmallIntReader();
    private static final FieldReader INT_READER = new IntReader();
    private static final FieldReader BIGINT_READER = new BigIntReader();
    private static final FieldReader FLOAT_READER = new FloatReader();
    private static final FieldReader DOUBLE_READER = new DoubleReader();
    private static final FieldReader TIMESTAMP_MILLS_READER = new TimestampMillsReader();
    private static final FieldReader TIMESTAMP_MICROS_READER = new TimestampMicrosReader();

    @Override
    public FieldReader visitUnion(Schema schema, @Nullable DataType type) {
        return new NullableReader((FieldReader)this.visit(schema.getTypes().get(1), type));
    }

    @Override
    public FieldReader visitString() {
        return STRING_READER;
    }

    @Override
    public FieldReader visitBytes() {
        return BYTES_READER;
    }

    @Override
    public FieldReader visitInt() {
        return INT_READER;
    }

    @Override
    public FieldReader visitTinyInt() {
        return TINYINT_READER;
    }

    @Override
    public FieldReader visitSmallInt() {
        return SMALLINT_READER;
    }

    @Override
    public FieldReader visitBoolean() {
        return BOOLEAN_READER;
    }

    @Override
    public FieldReader visitBigInt() {
        return BIGINT_READER;
    }

    @Override
    public FieldReader visitFloat() {
        return FLOAT_READER;
    }

    @Override
    public FieldReader visitDouble() {
        return DOUBLE_READER;
    }

    @Override
    public FieldReader visitTimestampMillis(@Nullable Integer precision) {
        return TIMESTAMP_MILLS_READER;
    }

    @Override
    public FieldReader visitTimestampMicros(@Nullable Integer precision) {
        return TIMESTAMP_MICROS_READER;
    }

    @Override
    public FieldReader visitDecimal(@Nullable Integer precision, @Nullable Integer scale) {
        return new DecimalReader(precision, scale);
    }

    @Override
    public FieldReader visitArray(Schema schema, @Nullable DataType elementType) {
        FieldReader elementReader = (FieldReader)this.visit(schema.getElementType(), elementType);
        return new ArrayReader(elementReader);
    }

    @Override
    public FieldReader visitArrayMap(Schema schema, DataType keyType, DataType valueType) {
        RowReader entryReader = new RowReader(schema.getElementType(), RowType.of(new DataType[]{keyType, valueType}, new String[]{"key", "value"}).getFields());
        return new ArrayMapReader(entryReader, keyType, valueType);
    }

    @Override
    public FieldReader visitMap(Schema schema, @Nullable DataType valueType) {
        FieldReader valueReader = (FieldReader)this.visit(schema.getValueType(), valueType);
        return new MapReader(valueReader);
    }

    @Override
    public FieldReader visitRecord(Schema schema, @NotNull List<DataField> fields) {
        return new RowReader(schema, fields);
    }

    public RowReader createRowReader(Schema schema, List<DataField> fields) {
        return new RowReader(schema, fields);
    }

    public class RowReader
    implements FieldReader {
        private final FieldReader[] fieldReaders;
        private final int[] mapping;
        private final int[] mappingBack;

        public RowReader(Schema schema, List<DataField> fields) {
            int i;
            List<Schema.Field> schemaFields = schema.getFields();
            this.mapping = new int[fields.size()];
            this.mappingBack = new int[schemaFields.size()];
            Arrays.fill(this.mappingBack, -1);
            for (i = 0; i < this.mapping.length; ++i) {
                DataField field = fields.get(i);
                Schema.Field schemaField = schema.getField(field.name());
                if (schemaField != null) {
                    int index;
                    this.mapping[i] = index = schemaFields.indexOf(schemaField);
                    this.mappingBack[index] = i;
                    continue;
                }
                this.mapping[i] = -1;
            }
            this.fieldReaders = new FieldReader[schemaFields.size()];
            int fieldsSize = schemaFields.size();
            for (i = 0; i < fieldsSize; ++i) {
                Schema.Field field = schemaFields.get(i);
                if (this.mappingBack[i] >= 0) {
                    DataType type = fields.get(this.mappingBack[i]).type();
                    this.fieldReaders[i] = (FieldReader)FieldReaderFactory.this.visit(field.schema(), type);
                    continue;
                }
                this.fieldReaders[i] = (FieldReader)FieldReaderFactory.this.visit(field.schema(), null);
            }
        }

        @Override
        public InternalRow read(Decoder decoder, Object reuse) throws IOException {
            int i;
            GenericRow row = reuse instanceof GenericRow && ((GenericRow)reuse).getFieldCount() == this.mapping.length ? (GenericRow)reuse : new GenericRow(this.mapping.length);
            Object[] values = new Object[this.fieldReaders.length];
            for (i = 0; i < this.fieldReaders.length; ++i) {
                if (this.mappingBack[i] >= 0) {
                    values[i] = this.fieldReaders[i].read(decoder, row.getField(this.mappingBack[i]));
                    continue;
                }
                this.fieldReaders[i].skip(decoder);
            }
            for (i = 0; i < this.mapping.length; ++i) {
                row.setField(i, this.mapping[i] >= 0 ? values[this.mapping[i]] : null);
            }
            return row;
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            for (FieldReader fieldReader : this.fieldReaders) {
                fieldReader.skip(decoder);
            }
        }
    }

    private static class MapReader
    implements FieldReader {
        private final FieldReader valueReader;
        private final List<Object> reusedKeyList = new ArrayList<Object>();
        private final List<Object> reusedValueList = new ArrayList<Object>();

        private MapReader(FieldReader valueReader) {
            this.valueReader = valueReader;
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readMapStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedKeyList.add(STRING_READER.read(decoder, null));
                    this.reusedValueList.add(this.valueReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.mapNext();
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Object[] keys = this.reusedKeyList.toArray();
            Object[] values = this.reusedValueList.toArray();
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
            return new GenericMap(map);
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            long chunkLength = decoder.readMapStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    STRING_READER.skip(decoder);
                    this.valueReader.skip(decoder);
                    ++i;
                }
                chunkLength = decoder.mapNext();
            }
        }
    }

    private static class ArrayMapReader
    implements FieldReader {
        private final RowReader entryReader;
        private final InternalRow.FieldGetter keyGetter;
        private final InternalRow.FieldGetter valueGetter;
        private final List<Object> reusedKeyList = new ArrayList<Object>();
        private final List<Object> reusedValueList = new ArrayList<Object>();

        private ArrayMapReader(RowReader entryReader, DataType keyType, DataType valueType) {
            this.entryReader = entryReader;
            this.keyGetter = InternalRow.createFieldGetter(keyType, 0);
            this.valueGetter = InternalRow.createFieldGetter(valueType, 1);
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            this.reusedKeyList.clear();
            this.reusedValueList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    InternalRow entry = this.entryReader.read(decoder, null);
                    this.reusedKeyList.add(this.keyGetter.getFieldOrNull(entry));
                    this.reusedValueList.add(this.valueGetter.getFieldOrNull(entry));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            Object[] keys = this.reusedKeyList.toArray();
            Object[] values = this.reusedValueList.toArray();
            for (int i = 0; i < keys.length; ++i) {
                map.put(keys[i], values[i]);
            }
            return new GenericMap(map);
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
        }
    }

    private static class ArrayReader
    implements FieldReader {
        private final FieldReader elementReader;
        private final List<Object> reusedList = new ArrayList<Object>();

        private ArrayReader(FieldReader elementReader) {
            this.elementReader = elementReader;
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            this.reusedList.clear();
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.reusedList.add(this.elementReader.read(decoder, null));
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
            return new GenericArray(this.reusedList.toArray());
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            long chunkLength = decoder.readArrayStart();
            while (chunkLength > 0L) {
                int i = 0;
                while ((long)i < chunkLength) {
                    this.elementReader.skip(decoder);
                    ++i;
                }
                chunkLength = decoder.arrayNext();
            }
        }
    }

    private static class TimestampMicrosReader
    implements FieldReader {
        private TimestampMicrosReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return Timestamp.fromMicros(decoder.readLong());
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readLong();
        }
    }

    private static class TimestampMillsReader
    implements FieldReader {
        private TimestampMillsReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return Timestamp.fromEpochMillis(decoder.readLong());
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readLong();
        }
    }

    private static class DecimalReader
    implements FieldReader {
        private final Integer precision;
        private final Integer scale;

        private DecimalReader(Integer precision, Integer scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            if (this.precision == null || this.scale == null) {
                throw new AvroRuntimeException("Can't reader record when precision or scale is null.");
            }
            byte[] bytes = (byte[])BYTES_READER.read(decoder, null);
            return Decimal.fromBigDecimal(new BigDecimal(new BigInteger(bytes), this.scale), this.precision, this.scale);
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            BYTES_READER.skip(decoder);
        }
    }

    private static class DoubleReader
    implements FieldReader {
        private DoubleReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readDouble();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readDouble();
        }
    }

    private static class FloatReader
    implements FieldReader {
        private FloatReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return Float.valueOf(decoder.readFloat());
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readFloat();
        }
    }

    private static class BigIntReader
    implements FieldReader {
        private BigIntReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readLong();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readLong();
        }
    }

    private static class IntReader
    implements FieldReader {
        private IntReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readInt();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readInt();
        }
    }

    private static class SmallIntReader
    implements FieldReader {
        private SmallIntReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return (short)decoder.readInt();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readInt();
        }
    }

    private static class TinyIntReader
    implements FieldReader {
        private TinyIntReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return (byte)decoder.readInt();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readInt();
        }
    }

    private static class BooleanReader
    implements FieldReader {
        private BooleanReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readBoolean();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.readBoolean();
        }
    }

    private static class BytesReader
    implements FieldReader {
        private BytesReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readBytes(null).array();
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.skipBytes();
        }
    }

    private static class StringReader
    implements FieldReader {
        private StringReader() {
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            Utf8 utf8 = null;
            if (reuse instanceof BinaryString) {
                utf8 = new Utf8(((BinaryString)reuse).toBytes());
            }
            Utf8 string = decoder.readString(utf8);
            return BinaryString.fromBytes(string.getBytes(), 0, string.getByteLength());
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            decoder.skipString();
        }
    }

    private static class NullableReader
    implements FieldReader {
        private final FieldReader reader;

        public NullableReader(FieldReader reader) {
            this.reader = reader;
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            int index = decoder.readIndex();
            return index == 0 ? null : this.reader.read(decoder, reuse);
        }

        @Override
        public void skip(Decoder decoder) throws IOException {
            int index = decoder.readIndex();
            if (index == 1) {
                this.reader.skip(decoder);
            }
        }
    }
}

