/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.iceberg.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.GenericMap;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.iceberg.manifest.IcebergConversions;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;

public class IcebergDataFileMeta {
    private final Content content;
    private final String filePath;
    private final String fileFormat;
    private final BinaryRow partition;
    private final long recordCount;
    private final long fileSizeInBytes;
    private final InternalMap nullValueCounts;
    private final InternalMap lowerBounds;
    private final InternalMap upperBounds;

    IcebergDataFileMeta(Content content, String filePath, String fileFormat, BinaryRow partition, long recordCount, long fileSizeInBytes, InternalMap nullValueCounts, InternalMap lowerBounds, InternalMap upperBounds) {
        this.content = content;
        this.filePath = filePath;
        this.fileFormat = fileFormat;
        this.partition = partition;
        this.recordCount = recordCount;
        this.fileSizeInBytes = fileSizeInBytes;
        this.nullValueCounts = nullValueCounts;
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds;
    }

    public static IcebergDataFileMeta create(Content content, String filePath, String fileFormat, BinaryRow partition, long recordCount, long fileSizeInBytes, TableSchema tableSchema, SimpleStats stats) {
        int i;
        HashMap<Integer, Long> nullValueCounts = new HashMap<Integer, Long>();
        HashMap<Integer, byte[]> lowerBounds = new HashMap<Integer, byte[]>();
        HashMap<Integer, byte[]> upperBounds = new HashMap<Integer, byte[]>();
        ArrayList<InternalRow.FieldGetter> fieldGetters = new ArrayList<InternalRow.FieldGetter>();
        int numFields = tableSchema.fields().size();
        for (i = 0; i < numFields; ++i) {
            fieldGetters.add(InternalRow.createFieldGetter(tableSchema.fields().get(i).type(), i));
        }
        for (i = 0; i < numFields; ++i) {
            int fieldId = tableSchema.fields().get(i).id();
            DataType type = tableSchema.fields().get(i).type();
            nullValueCounts.put(fieldId, stats.nullCounts().getLong(i));
            Object minValue = ((InternalRow.FieldGetter)fieldGetters.get(i)).getFieldOrNull(stats.minValues());
            Object maxValue = ((InternalRow.FieldGetter)fieldGetters.get(i)).getFieldOrNull(stats.maxValues());
            if (minValue == null || maxValue == null) continue;
            lowerBounds.put(fieldId, IcebergConversions.toByteBuffer(type, minValue).array());
            upperBounds.put(fieldId, IcebergConversions.toByteBuffer(type, maxValue).array());
        }
        return new IcebergDataFileMeta(content, filePath, fileFormat, partition, recordCount, fileSizeInBytes, new GenericMap(nullValueCounts), new GenericMap(lowerBounds), new GenericMap(upperBounds));
    }

    public Content content() {
        return this.content;
    }

    public String filePath() {
        return this.filePath;
    }

    public String fileFormat() {
        return this.fileFormat;
    }

    public BinaryRow partition() {
        return this.partition;
    }

    public long recordCount() {
        return this.recordCount;
    }

    public long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public InternalMap nullValueCounts() {
        return this.nullValueCounts;
    }

    public InternalMap lowerBounds() {
        return this.lowerBounds;
    }

    public InternalMap upperBounds() {
        return this.upperBounds;
    }

    public static RowType schema(RowType partitionType) {
        ArrayList<DataField> fields = new ArrayList<DataField>();
        fields.add(new DataField(134, "content", DataTypes.INT().notNull()));
        fields.add(new DataField(100, "file_path", DataTypes.STRING().notNull()));
        fields.add(new DataField(101, "file_format", DataTypes.STRING().notNull()));
        fields.add(new DataField(102, "partition", partitionType));
        fields.add(new DataField(103, "record_count", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(104, "file_size_in_bytes", DataTypes.BIGINT().notNull()));
        fields.add(new DataField(110, "null_value_counts", DataTypes.MAP(DataTypes.INT().notNull(), DataTypes.BIGINT().notNull())));
        fields.add(new DataField(125, "lower_bounds", DataTypes.MAP(DataTypes.INT().notNull(), DataTypes.BYTES().notNull())));
        fields.add(new DataField(128, "upper_bounds", DataTypes.MAP(DataTypes.INT().notNull(), DataTypes.BYTES().notNull())));
        return new RowType(fields);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergDataFileMeta that = (IcebergDataFileMeta)o;
        return this.content == that.content && this.recordCount == that.recordCount && this.fileSizeInBytes == that.fileSizeInBytes && Objects.equals(this.filePath, that.filePath) && Objects.equals(this.fileFormat, that.fileFormat) && Objects.equals(this.partition, that.partition) && Objects.equals(this.nullValueCounts, that.nullValueCounts) && Objects.equals(this.lowerBounds, that.lowerBounds) && Objects.equals(this.upperBounds, that.upperBounds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.filePath, this.fileFormat, this.partition, this.recordCount, this.fileSizeInBytes, this.nullValueCounts, this.lowerBounds, this.upperBounds});
    }

    public static enum Content {
        DATA(0),
        POSITION_DELETES(1),
        EQUALITY_DELETES(2);

        private final int id;

        private Content(int id) {
            this.id = id;
        }

        public int id() {
            return this.id;
        }

        public static Content fromId(int id) {
            switch (id) {
                case 0: {
                    return DATA;
                }
                case 1: {
                    return POSITION_DELETES;
                }
                case 2: {
                    return EQUALITY_DELETES;
                }
            }
            throw new IllegalArgumentException("Unknown manifest content: " + id);
        }
    }
}

