/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.spark.SparkArrayData;
import org.apache.paimon.spark.util.shim.TypeUtils;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeChecks;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.MultisetType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class SparkInternalRow
extends InternalRow {
    private final RowType rowType;
    private org.apache.paimon.data.InternalRow row;

    public SparkInternalRow(RowType rowType) {
        this.rowType = rowType;
    }

    public SparkInternalRow replace(org.apache.paimon.data.InternalRow row) {
        this.row = row;
        return this;
    }

    public int numFields() {
        return this.row.getFieldCount();
    }

    public void setNullAt(int i) {
        throw new UnsupportedOperationException();
    }

    public void update(int i, Object value) {
        throw new UnsupportedOperationException();
    }

    public InternalRow copy() {
        return new SparkInternalRow(this.rowType).replace(InternalRowUtils.copyInternalRow(this.row, this.rowType));
    }

    public boolean isNullAt(int ordinal) {
        return this.row.isNullAt(ordinal);
    }

    public boolean getBoolean(int ordinal) {
        return this.row.getBoolean(ordinal);
    }

    public byte getByte(int ordinal) {
        return this.row.getByte(ordinal);
    }

    public short getShort(int ordinal) {
        return this.row.getShort(ordinal);
    }

    public int getInt(int ordinal) {
        return this.row.getInt(ordinal);
    }

    public long getLong(int ordinal) {
        if (this.rowType.getTypeAt(ordinal) instanceof BigIntType) {
            return this.row.getLong(ordinal);
        }
        return this.getTimestampMicros(ordinal);
    }

    private long getTimestampMicros(int ordinal) {
        DataType type = this.rowType.getTypeAt(ordinal);
        return SparkInternalRow.fromPaimon(this.row.getTimestamp(ordinal, DataTypeChecks.getPrecision(type)));
    }

    public float getFloat(int ordinal) {
        return this.row.getFloat(ordinal);
    }

    public double getDouble(int ordinal) {
        return this.row.getDouble(ordinal);
    }

    public Decimal getDecimal(int ordinal, int precision, int scale) {
        org.apache.paimon.data.Decimal decimal = this.row.getDecimal(ordinal, precision, scale);
        return SparkInternalRow.fromPaimon(decimal);
    }

    public UTF8String getUTF8String(int ordinal) {
        return SparkInternalRow.fromPaimon(this.row.getString(ordinal));
    }

    public byte[] getBinary(int ordinal) {
        return this.row.getBinary(ordinal);
    }

    public CalendarInterval getInterval(int ordinal) {
        throw new UnsupportedOperationException();
    }

    public InternalRow getStruct(int ordinal, int numFields) {
        return SparkInternalRow.fromPaimon(this.row.getRow(ordinal, numFields), (RowType)this.rowType.getTypeAt(ordinal));
    }

    public ArrayData getArray(int ordinal) {
        return SparkInternalRow.fromPaimon(this.row.getArray(ordinal), (ArrayType)this.rowType.getTypeAt(ordinal));
    }

    public MapData getMap(int ordinal) {
        return SparkInternalRow.fromPaimon(this.row.getMap(ordinal), this.rowType.getTypeAt(ordinal));
    }

    public Object get(int ordinal, org.apache.spark.sql.types.DataType dataType) {
        if (this.isNullAt(ordinal) || dataType instanceof NullType) {
            return null;
        }
        if (dataType instanceof BooleanType) {
            return this.getBoolean(ordinal);
        }
        if (dataType instanceof ByteType) {
            return this.getByte(ordinal);
        }
        if (dataType instanceof ShortType) {
            return this.getShort(ordinal);
        }
        if (dataType instanceof IntegerType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof LongType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.getFloat(ordinal));
        }
        if (dataType instanceof DoubleType) {
            return this.getDouble(ordinal);
        }
        if (dataType instanceof StringType || dataType instanceof CharType || dataType instanceof VarcharType) {
            return this.getUTF8String(ordinal);
        }
        if (dataType instanceof DecimalType) {
            DecimalType dt = (DecimalType)dataType;
            return this.getDecimal(ordinal, dt.precision(), dt.scale());
        }
        if (dataType instanceof DateType) {
            return this.getInt(ordinal);
        }
        if (dataType instanceof TimestampType) {
            return this.getLong(ordinal);
        }
        if (dataType instanceof CalendarIntervalType) {
            return this.getInterval(ordinal);
        }
        if (dataType instanceof BinaryType) {
            return this.getBinary(ordinal);
        }
        if (dataType instanceof StructType) {
            return this.getStruct(ordinal, ((StructType)dataType).size());
        }
        if (dataType instanceof org.apache.spark.sql.types.ArrayType) {
            return this.getArray(ordinal);
        }
        if (dataType instanceof MapType) {
            return this.getMap(ordinal);
        }
        if (dataType instanceof UserDefinedType) {
            return this.get(ordinal, ((UserDefinedType)dataType).sqlType());
        }
        throw new UnsupportedOperationException("Unsupported data type " + dataType.simpleString());
    }

    public static Object fromPaimon(Object o, DataType type) {
        if (o == null) {
            return null;
        }
        switch (type.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return SparkInternalRow.fromPaimon((org.apache.paimon.data.Timestamp)o);
            }
            case CHAR: 
            case VARCHAR: {
                return SparkInternalRow.fromPaimon((BinaryString)o);
            }
            case DECIMAL: {
                return SparkInternalRow.fromPaimon((org.apache.paimon.data.Decimal)o);
            }
            case ARRAY: {
                return SparkInternalRow.fromPaimon((InternalArray)o, (ArrayType)type);
            }
            case MAP: 
            case MULTISET: {
                return SparkInternalRow.fromPaimon((InternalMap)o, type);
            }
            case ROW: {
                return SparkInternalRow.fromPaimon((org.apache.paimon.data.InternalRow)o, (RowType)type);
            }
        }
        return o;
    }

    public static UTF8String fromPaimon(BinaryString string) {
        return UTF8String.fromBytes((byte[])string.toBytes());
    }

    public static Decimal fromPaimon(org.apache.paimon.data.Decimal decimal) {
        return Decimal.apply((BigDecimal)decimal.toBigDecimal());
    }

    public static InternalRow fromPaimon(org.apache.paimon.data.InternalRow row, RowType rowType) {
        return new SparkInternalRow(rowType).replace(row);
    }

    public static long fromPaimon(org.apache.paimon.data.Timestamp timestamp) {
        if (TypeUtils.treatPaimonTimestampTypeAsSparkTimestampType()) {
            return DateTimeUtils.fromJavaTimestamp((Timestamp)timestamp.toSQLTimestamp());
        }
        return timestamp.toMicros();
    }

    public static ArrayData fromPaimon(InternalArray array, ArrayType arrayType) {
        return SparkInternalRow.fromPaimonArrayElementType(array, arrayType.getElementType());
    }

    private static ArrayData fromPaimonArrayElementType(InternalArray array, DataType elementType) {
        return new SparkArrayData(elementType).replace(array);
    }

    public static MapData fromPaimon(InternalMap map, DataType mapType) {
        DataType valueType;
        DataType keyType;
        if (mapType instanceof org.apache.paimon.types.MapType) {
            keyType = ((org.apache.paimon.types.MapType)mapType).getKeyType();
            valueType = ((org.apache.paimon.types.MapType)mapType).getValueType();
        } else if (mapType instanceof MultisetType) {
            keyType = ((MultisetType)mapType).getElementType();
            valueType = new IntType();
        } else {
            throw new UnsupportedOperationException("Unsupported type: " + mapType);
        }
        return new ArrayBasedMapData(SparkInternalRow.fromPaimonArrayElementType(map.keyArray(), keyType), SparkInternalRow.fromPaimonArrayElementType(map.valueArray(), valueType));
    }
}

