/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.spark.procedure;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.FileStore;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.operation.PartitionExpire;
import org.apache.paimon.partition.PartitionExpireStrategy;
import org.apache.paimon.spark.procedure.BaseProcedure;
import org.apache.paimon.spark.procedure.ProcedureBuilder;
import org.apache.paimon.spark.procedure.ProcedureParameter;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.TimeUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class ExpirePartitionsProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("expiration_time", DataTypes.StringType), ProcedureParameter.optional("timestamp_formatter", DataTypes.StringType), ProcedureParameter.optional("timestamp_pattern", DataTypes.StringType), ProcedureParameter.optional("expire_strategy", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("expired_partitions", DataTypes.StringType, true, Metadata.empty())});

    protected ExpirePartitionsProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String expirationTime = args.getString(1);
        String timestampFormatter = args.isNullAt(2) ? null : args.getString(2);
        String timestampPattern = args.isNullAt(3) ? null : args.getString(3);
        String expireStrategy = args.isNullAt(4) ? null : args.getString(4);
        return this.modifyPaimonTable(tableIdent, table -> {
            InternalRow[] internalRowArray;
            FileStoreTable fileStoreTable = (FileStoreTable)table;
            FileStore<?> fileStore = fileStoreTable.store();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(CoreOptions.PARTITION_EXPIRATION_STRATEGY.key(), expireStrategy);
            map.put(CoreOptions.PARTITION_TIMESTAMP_FORMATTER.key(), timestampFormatter);
            map.put(CoreOptions.PARTITION_TIMESTAMP_PATTERN.key(), timestampPattern);
            PartitionExpire partitionExpire = new PartitionExpire(TimeUtils.parseDuration(expirationTime), Duration.ofMillis(0L), PartitionExpireStrategy.createPartitionExpireStrategy(CoreOptions.fromMap(map), fileStore.partitionType()), fileStore.newScan(), fileStore.newCommit(""), Optional.ofNullable(fileStoreTable.catalogEnvironment().metastoreClientFactory()).map(MetastoreClient.Factory::create).orElse(null));
            List<Map<String, String>> expired = partitionExpire.expire(Long.MAX_VALUE);
            if (expired == null || expired.isEmpty()) {
                InternalRow[] internalRowArray2 = new InternalRow[1];
                internalRowArray = internalRowArray2;
                internalRowArray2[0] = this.newInternalRow(UTF8String.fromString((String)"No expired partitions."));
            } else {
                internalRowArray = (InternalRow[])expired.stream().map(x -> {
                    String r = x.toString();
                    return this.newInternalRow(UTF8String.fromString((String)r.substring(1, r.length() - 1)));
                }).toArray(InternalRow[]::new);
            }
            return internalRowArray;
        });
    }

    public static ProcedureBuilder builder() {
        return new BaseProcedure.Builder<ExpirePartitionsProcedure>(){

            @Override
            public ExpirePartitionsProcedure doBuild() {
                return new ExpirePartitionsProcedure(this.tableCatalog());
            }
        };
    }

    @Override
    public String description() {
        return "ExpirePartitionsProcedure";
    }
}

